/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IniFile {
    private static final Pattern PATTERN_SECTION = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private static final Pattern PATTERN_KEY = Pattern.compile("\\s*([^=]*)=(.*)");
    private Map<String, Map<String, String>> entries = new HashMap<String, Map<String, String>>();

    public void load(String path) throws IOException {
        this.entries.clear();
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String line;
            String section = null;
            while ((line = br.readLine()) != null) {
                Matcher m = PATTERN_SECTION.matcher(line);
                if (m.matches()) {
                    section = m.group(1).trim();
                    continue;
                }
                if (section == null || !(m = PATTERN_KEY.matcher(line)).matches()) continue;
                this.entries.computeIfAbsent(section, s -> new HashMap()).put(m.group(1).trim(), m.group(2).trim());
            }
        }
    }

    public Map<String, String> getSection(String section) {
        return this.entries.get(section);
    }

    public String getString(String section, String key, String defaultvalue) {
        Map<String, String> kv = this.entries.get(section);
        return kv == null ? defaultvalue : kv.get(key);
    }

    public int getInt(String section, String key, int defaultvalue) {
        Map<String, String> kv = this.entries.get(section);
        return kv == null ? defaultvalue : Integer.parseInt(kv.get(key));
    }

    public float getFloat(String section, String key, float defaultvalue) {
        Map<String, String> kv = this.entries.get(section);
        return kv == null ? defaultvalue : Float.parseFloat(kv.get(key));
    }

    public double getDouble(String section, String key, double defaultvalue) {
        Map<String, String> kv = this.entries.get(section);
        return kv == null ? defaultvalue : Double.parseDouble(kv.get(key));
    }
}

