/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device;

import de.mossgrabers.reaper.framework.device.Device;
import de.mossgrabers.reaper.framework.device.DeviceCollection;
import de.mossgrabers.reaper.framework.device.DeviceFileType;
import de.mossgrabers.reaper.framework.device.DeviceLocation;
import de.mossgrabers.reaper.framework.device.DeviceType;
import de.mossgrabers.reaper.framework.device.IniFile;
import de.mossgrabers.transformator.util.LogModel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceManager {
    private static final Pattern PATTERN_VST = Pattern.compile(".+?,.+?,(.+?)(\\!\\!\\!VSTi)?");
    private static final Pattern PATTERN_COMPANY = Pattern.compile("(.*?)\\s*\\((.*?)\\)");
    private static final Pattern PATTERN_JSFX = Pattern.compile("NAME\\s?((\")?.+?(\")?)\\s?\"(.+?)\"");
    private static final Set<String> NON_CATEGORIES = new HashSet<String>();
    private final List<Device> devices = new ArrayList<Device>();
    private final Set<String> categories = new TreeSet<String>();
    private final Set<String> vendors = new TreeSet<String>();
    private final List<DeviceCollection> collections = new ArrayList<DeviceCollection>();
    private static final DeviceManager INSTANCE;

    private DeviceManager() {
    }

    public static DeviceManager get() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumDevices() {
        List<Device> list = this.devices;
        synchronized (list) {
            return this.devices.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Device> getAll() {
        List<Device> list = this.devices;
        synchronized (list) {
            return new ArrayList<Device>(this.devices);
        }
    }

    public List<Device> filterByFileType(DeviceFileType deviceFileType) {
        return this.filterBy(deviceFileType, null, null, null, null, null);
    }

    public List<Device> filterByCategory(String category) {
        return this.filterBy(null, category, null, null, null, null);
    }

    public List<Device> filterByVendor(String vendor) {
        return this.filterBy(null, null, vendor, null, null, null);
    }

    public List<Device> filterByCollection(DeviceCollection collection) {
        return this.filterBy(null, null, null, collection, null, null);
    }

    public List<Device> filterByLocation(DeviceLocation location) {
        return this.filterBy(null, null, null, null, location, null);
    }

    public List<Device> filterByType(DeviceType deviceType) {
        return this.filterBy(null, null, null, null, null, deviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Device> filterBy(DeviceFileType fileType, String category, String vendor, DeviceCollection collection, DeviceLocation location, DeviceType deviceType) {
        ArrayList<Device> results = new ArrayList<Device>();
        List<Device> list = this.devices;
        synchronized (list) {
            for (Device d : this.devices) {
                if (fileType != null && d.getFileType() != fileType || category != null && !d.hasCategory(category) || vendor != null && !vendor.equals(d.getVendor()) || location != null && d.getLocation() != location || deviceType != null && d.getType() != deviceType) continue;
                results.add(d);
            }
        }
        return collection == null ? results : collection.filter(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadINIFiles(String iniPath, LogModel logModel) {
        List<Device> list = this.devices;
        synchronized (list) {
            this.clearCache();
            IniFile iniFile = new IniFile();
            if (DeviceManager.loadINIFile(iniPath + File.separator + "reaper-vstplugins64.ini", iniFile, logModel)) {
                this.parseDevicesFile(iniFile);
            }
            if (DeviceManager.loadINIFile(iniPath + File.separator + "reaper-fxtags.ini", iniFile, logModel)) {
                this.parseFXTagsFile(iniFile);
            }
            this.loadJSDevices(iniPath + File.separator + "reaper-jsfx.ini", logModel);
            if (DeviceManager.loadINIFile(iniPath + File.separator + "reaper-fxfolders.ini", iniFile, logModel)) {
                this.parseCollectionFilters(iniFile);
            }
            this.devices.sort((d1, d2) -> d1.getDisplayName().compareToIgnoreCase(d2.getDisplayName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCategories() {
        List<Device> list = this.devices;
        synchronized (list) {
            return this.categories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getVendors() {
        List<Device> list = this.devices;
        synchronized (list) {
            return this.vendors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceCollection> getCollections() {
        List<Device> list = this.devices;
        synchronized (list) {
            return this.collections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceCollection getCollection(String collectionName) {
        List<Device> list = this.devices;
        synchronized (list) {
            for (DeviceCollection collection : this.collections) {
                if (!collection.getName().equals(collectionName)) continue;
                return collection;
            }
        }
        return null;
    }

    private void parseDevicesFile(IniFile iniFile) {
        Map<String, String> vstcacheSection = iniFile.getSection("vstcache");
        for (Map.Entry<String, String> entry : vstcacheSection.entrySet()) {
            Device device = DeviceManager.parseDevice(entry.getKey(), entry.getValue());
            if (device == null) continue;
            this.devices.add(device);
        }
    }

    private void parseFXTagsFile(IniFile iniFile) {
        for (Device d : this.devices) {
            String vendor;
            String categoriesStr = iniFile.getString("category", d.getModule(), null);
            if (categoriesStr != null) {
                List<String> asList = Arrays.asList(categoriesStr.split("\\|"));
                d.setCategories(asList);
                this.categories.addAll(asList);
            }
            if ((vendor = iniFile.getString("developer", d.getModule(), null)) == null) continue;
            d.setVendor(vendor);
            this.vendors.add(vendor);
        }
    }

    private void parseCollectionFilters(IniFile iniFile) {
        for (int i = 0; i < iniFile.getInt("Folders", "NbFolders", 0); ++i) {
            int id = iniFile.getInt("Folders", "Id" + i, -1);
            if (id < 0) continue;
            String collectionName = iniFile.getString("Folders", "Name" + i, "");
            DeviceCollection deviceCollection = new DeviceCollection(collectionName);
            this.collections.add(deviceCollection);
            String collectionSection = "Folder" + id;
            for (int j = 0; j < iniFile.getInt(collectionSection, "Nb", 0); ++j) {
                String item = iniFile.getString(collectionSection, "Item" + j, "");
                int type = iniFile.getInt(collectionSection, "Type" + j, 0);
                deviceCollection.addItem(item, type);
            }
        }
    }

    private static Device parseDevice(String module, String nameAndCompany) {
        Matcher matcher = PATTERN_VST.matcher(nameAndCompany);
        if (!matcher.matches()) {
            return null;
        }
        String creationName = matcher.group(1);
        if ("<SHELL>".equals(creationName)) {
            return null;
        }
        Matcher companyMatcher = PATTERN_COMPANY.matcher(creationName);
        if (!companyMatcher.matches()) {
            return null;
        }
        String name = companyMatcher.group(1);
        String type = matcher.group(2);
        DeviceFileType dt = "!!!VSTi".equals(type) ? (module.endsWith("vst3") ? DeviceFileType.VST3I : DeviceFileType.VSTI) : (module.endsWith("vst3") ? DeviceFileType.VST3 : DeviceFileType.VST);
        return new Device(creationName, name, module, dt);
    }

    private void clearCache() {
        this.devices.clear();
        this.categories.clear();
        this.vendors.clear();
        this.collections.clear();
    }

    private void loadJSDevices(String filename, LogModel logModel) {
        Path path = Paths.get(filename, new String[0]);
        try {
            if (path.toFile().exists()) {
                Files.readAllLines(path, Charset.forName("UTF-8")).forEach(this::parseJSDevice);
            } else {
                logModel.addLogMessage(filename + " not present, skipped loading.");
            }
        }
        catch (IOException ex) {
            logModel.addLogMessage("Could not load file: " + path);
            logModel.addLogMessage(ex.getClass() + ":" + ex.getMessage());
        }
    }

    private void parseJSDevice(String line) {
        String o;
        Matcher matcher = PATTERN_JSFX.matcher(line);
        if (!matcher.matches()) {
            return;
        }
        String name = matcher.group(4).substring(4);
        String module = matcher.group(1);
        Device device = new Device(module, name, module, DeviceFileType.JS);
        this.devices.add(device);
        String[] modulePath = module.split("/");
        if (modulePath.length <= 1) {
            return;
        }
        String string = o = modulePath[0].startsWith("\"") ? modulePath[0].substring(1) : modulePath[0];
        if (NON_CATEGORIES.contains(o.toLowerCase())) {
            device.setVendor(o);
            this.vendors.add(o);
        } else {
            device.setCategories(Collections.singleton(o));
            this.categories.add(o);
        }
    }

    private static boolean loadINIFile(String filename, IniFile iniFile, LogModel logModel) {
        try {
            File file = new File(filename);
            if (file.exists()) {
                iniFile.load(file.getAbsolutePath());
                return true;
            }
            logModel.addLogMessage(filename + " not present, skipped loading.");
        }
        catch (IOException ex) {
            logModel.addLogMessage("Could not load file: " + filename);
            logModel.addLogMessage(ex.getClass() + ":" + ex.getMessage());
        }
        return false;
    }

    static {
        Collections.addAll(NON_CATEGORIES, "ix", "till", "loser", "liteon", "sstillwell", "teej", "schwa", "u-he", "remaincalm_org");
        INSTANCE = new DeviceManager();
    }
}

