/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device;

import de.mossgrabers.reaper.framework.device.Device;
import de.mossgrabers.reaper.framework.device.DeviceFileType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DeviceCollection {
    private static final int TYPE_JS = 2;
    private static final int TYPE_VST = 3;
    private static final int TYPE_QUERY = 0x100000;
    private final String name;
    private final Map<String, Integer> items = new HashMap<String, Integer>();

    public DeviceCollection(String name) {
        this.name = name;
    }

    public void addItem(String item, int type) {
        this.items.put(item, type);
    }

    public String getName() {
        return this.name;
    }

    public List<Device> filter(List<Device> devices) {
        ArrayList<Device> results = new ArrayList<Device>();
        for (Device d : devices) {
            if (!this.testDevice(d)) continue;
            results.add(d);
        }
        return results;
    }

    private boolean testDevice(Device d) {
        for (Map.Entry<String, Integer> e : this.items.entrySet()) {
            boolean isJS = d.getFileType().equals((Object)DeviceFileType.JS);
            String key = e.getKey();
            switch (e.getValue()) {
                case 2: {
                    if (!isJS || !key.equals(d.getModule())) break;
                    return true;
                }
                case 3: {
                    if (isJS || !DeviceCollection.compareModules(key, d.getModule())) break;
                    return true;
                }
                case 0x100000: {
                    if (!DeviceCollection.compareQuery(key, d)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean compareQuery(String query, Device d) {
        HashSet<String> mustMatch = new HashSet<String>();
        HashSet<String> mustNotMatch = new HashSet<String>();
        for (String part : query.split(" OR ")) {
            String[] notParts = part.split(" NOT ");
            mustMatch.add(notParts[0].toLowerCase());
            for (int i = 1; i < notParts.length; ++i) {
                mustNotMatch.add(notParts[i].toLowerCase());
            }
        }
        String text = (d.getName() + " " + d.getVendor() + " " + (Object)((Object)d.getFileType())).toLowerCase();
        boolean success = mustMatch.isEmpty();
        for (String match : mustMatch) {
            if (!text.contains(match)) continue;
            success = true;
            break;
        }
        if (!success) {
            return false;
        }
        for (String notMatch : mustNotMatch) {
            if (!text.contains(notMatch)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareModules(String modulePath, String module) {
        String[] split = modulePath.split("[\\\\/]");
        if (split == null || split.length == 0) {
            return false;
        }
        String filename = split[split.length - 1].replace(' ', '_').replace('(', '_').replace(')', '_');
        return filename.equals(module);
    }
}

