/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device;

import de.mossgrabers.reaper.framework.device.DeviceFileType;
import de.mossgrabers.reaper.framework.device.DeviceLocation;
import de.mossgrabers.reaper.framework.device.DeviceType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Device {
    private final String name;
    private final String module;
    private final DeviceFileType fileType;
    private final String creationName;
    private String vendor;
    private final Set<String> categories = new HashSet<String>(1);

    public Device(String creationName, String name, String module, DeviceFileType type) {
        this.creationName = creationName;
        this.name = name;
        this.module = module;
        this.fileType = type;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name + " (" + this.fileType.getName() + ")";
    }

    public String getCreationName() {
        return this.creationName;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getModule() {
        return this.module;
    }

    public DeviceFileType getFileType() {
        return this.fileType;
    }

    public DeviceLocation getLocation() {
        return this.fileType == DeviceFileType.JS ? DeviceLocation.JS : DeviceLocation.VST;
    }

    public void setCategories(Collection<String> categories) {
        this.categories.addAll(categories);
    }

    public boolean hasCategory(String category) {
        return this.categories.contains(category);
    }

    public DeviceType getType() {
        if (this.fileType == DeviceFileType.VST || this.fileType == DeviceFileType.VST3) {
            return DeviceType.AUDIO_EFFECT;
        }
        if (this.fileType == DeviceFileType.VSTI || this.fileType == DeviceFileType.VST3I) {
            return DeviceType.INSTRUMENT;
        }
        return this.hasCategory("MIDI") ? DeviceType.MIDI_EFFECT : DeviceType.AUDIO_EFFECT;
    }
}

