/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.reaper.framework.daw.data.ChannelImpl;
import de.mossgrabers.reaper.framework.daw.data.SlotImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public class TrackImpl
extends ChannelImpl
implements ITrack {
    public static final int MONITOR_OFF = 0;
    public static final int MONITOR_ON = 1;
    public static final int MONITOR_AUTO = 2;
    public static final String AUTOMATION_TRIM = "trim";
    public static final String AUTOMATION_READ = "read";
    public static final String AUTOMATION_TOUCH = "touch";
    public static final String AUTOMATION_LATCH = "latch";
    public static final String AUTOMATION_WRITE = "write";
    private ISlot[] slots;
    private int position;
    private boolean isRecArm;
    private boolean monitor;
    private boolean autoMonitor;
    private String automation = "trim";
    private boolean isRepeat;
    private int repeatNoteLength;

    public TrackImpl(IHost host, MessageSender sender, IValueChanger valueChanger, int index, int numSends, int numScenes) {
        super(host, sender, valueChanger, index, numSends);
        this.slots = new SlotImpl[numScenes];
        for (int i = 0; i < numScenes; ++i) {
            this.slots[i] = new SlotImpl(sender, index, i);
        }
    }

    @Override
    public void enableObservers(boolean enable) {
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public boolean isRecArm() {
        return this.doesExist() && this.isRecArm;
    }

    @Override
    public void setRecArm(boolean value) {
        this.setRecArmState(value);
        this.sendTrackOSC("recarm", value);
    }

    @Override
    public void toggleRecArm() {
        this.setRecArm(!this.isRecArm());
    }

    @Override
    public boolean isMonitor() {
        return this.doesExist() && this.monitor;
    }

    @Override
    public void setMonitor(boolean value) {
        this.setMonitorState(value);
        this.sendTrackOSC("monitor", this.monitor ? 1 : 0);
    }

    @Override
    public void toggleMonitor() {
        this.setMonitor(!this.monitor);
    }

    @Override
    public boolean isAutoMonitor() {
        return this.doesExist() && this.autoMonitor;
    }

    @Override
    public boolean canHoldNotes() {
        return true;
    }

    @Override
    public void setAutoMonitor(boolean value) {
        this.setAutoMonitorState(value);
        this.sendTrackOSC("autoMonitor", this.autoMonitor ? 1 : 0);
    }

    @Override
    public void toggleAutoMonitor() {
        this.setAutoMonitor(!this.autoMonitor);
    }

    @Override
    public boolean canHoldAudioData() {
        return true;
    }

    @Override
    public int getNumSlots() {
        return this.slots.length;
    }

    @Override
    public ISlot getSlot(int slotIndex) {
        return this.slots[slotIndex];
    }

    @Override
    public boolean isPlaying() {
        return false;
    }

    @Override
    public void select() {
        this.sendTrackOSC("select", 1);
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setRecArmState(boolean isRecArm) {
        this.isRecArm = isRecArm;
    }

    public void setMonitorState(boolean monitorState) {
        this.monitor = monitorState;
    }

    public void setAutoMonitorState(boolean autoMonitorState) {
        this.autoMonitor = autoMonitorState;
    }

    public void setAutomation(String automation) {
        this.automation = automation;
    }

    public String getAutomation() {
        return this.automation;
    }

    public void setInternalRepeat(boolean enable) {
        this.isRepeat = enable;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }

    public void setInternalRepeatNoteLength(int length) {
        this.repeatNoteLength = length;
    }

    public int getRepeatNoteLength() {
        return this.repeatNoteLength;
    }

    @Override
    public void scrollClipPageBackwards() {
    }

    @Override
    public void scrollClipPageForwards() {
    }

    @Override
    public ISlot[] getSelectedSlots() {
        return new ISlot[]{this.slots[0]};
    }

    @Override
    public ISlot getSelectedSlot() {
        return this.slots[0];
    }

    @Override
    public ISlot getEmptySlot(int startFrom) {
        return this.slots[0];
    }

    @Override
    public void changeCrossfadeModeAsNumber(int control) {
    }

    @Override
    public String getCrossfadeMode() {
        return "AB";
    }

    @Override
    public void setCrossfadeMode(String mode) {
    }

    @Override
    public int getCrossfadeModeAsNumber() {
        return 1;
    }

    @Override
    public void setCrossfadeModeAsNumber(int modeValue) {
    }

    @Override
    public void toggleCrossfadeMode() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void returnToArrangement() {
    }
}

