/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public class ParameterImpl
extends BaseImpl
implements IParameter {
    protected IValueChanger valueChanger;
    protected int index;
    private String name = "";
    private String valueStr = "";
    private boolean isBeingTouched;
    protected int value;
    protected int lastReceivedValue = -1;

    public ParameterImpl(MessageSender sender, IValueChanger valueChanger, int index) {
        super(sender, null);
        this.valueChanger = valueChanger;
        this.index = index;
    }

    @Override
    public boolean doesExist() {
        return !this.name.isEmpty();
    }

    @Override
    public void inc(double increment) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(int limit) {
        return StringUtils.optimizeName(this.name, limit);
    }

    @Override
    public String getDisplayedValue() {
        return this.valueStr;
    }

    @Override
    public String getDisplayedValue(int limit) {
        int length = this.valueStr.length();
        return length > limit ? this.valueStr.substring(0, length) : this.valueStr;
    }

    @Override
    public int getValue() {
        return Math.max(this.value, 0);
    }

    @Override
    public void changeValue(int value) {
        this.setValue(this.valueChanger.changeValue(value, this.getValue()));
    }

    @Override
    public void setValue(double value) {
        if (!this.doesExist()) {
            return;
        }
        this.value = (int)value;
        this.sender.sendOSC("/device/param/" + (this.index + 1) + "/value", this.valueChanger.toNormalizedValue(this.getValue()));
    }

    @Override
    public int getModulatedValue() {
        return this.getValue();
    }

    @Override
    public void setIndication(boolean enable) {
    }

    @Override
    public void resetValue() {
        this.setValue(0.0);
    }

    @Override
    public void touchValue(boolean isBeingTouched) {
        this.isBeingTouched = isBeingTouched;
        if (this.isBeingTouched || this.lastReceivedValue == -1) {
            return;
        }
        this.value = this.lastReceivedValue;
        this.lastReceivedValue = -1;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public void setInternalValue(int value) {
        if (this.isBeingTouched) {
            this.lastReceivedValue = value;
        } else {
            this.value = value;
        }
    }

    public void setValueStr(String valueStr) {
        this.valueStr = valueStr == null ? "" : valueStr;
    }
}

