/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.TrackSelectionObserver;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.transformator.communication.MessageSender;
import java.util.ArrayList;
import java.util.List;

public class MasterTrackImpl
extends TrackImpl
implements IMasterTrack {
    private final List<TrackSelectionObserver> observers = new ArrayList<TrackSelectionObserver>();

    public MasterTrackImpl(IHost host, MessageSender sender, IValueChanger valueChanger) {
        super(host, sender, valueChanger, -1, 8, 0);
        this.valueChanger = valueChanger;
    }

    @Override
    public void addTrackSelectionObserver(TrackSelectionObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public String getName() {
        return "Master";
    }

    @Override
    public ChannelType getType() {
        return ChannelType.MASTER;
    }

    @Override
    public void setVolume(double value) {
        this.volume = (int)value;
        this.sender.sendOSC("/master/volume", this.valueChanger.toNormalizedValue(this.volume));
    }

    @Override
    public void setSelected(boolean isSelected) {
        super.setSelected(isSelected);
        for (TrackSelectionObserver observer : this.observers) {
            observer.call(-1, isSelected);
        }
    }

    @Override
    public void touchVolume(boolean isBeingTouched) {
        this.sender.sendOSC("/master/volume/touch", isBeingTouched ? 1 : 0);
        this.handleVolumeTouch(isBeingTouched);
    }

    @Override
    public void setPan(double value) {
        this.pan = (int)value;
        this.sender.sendOSC("/master/pan", this.valueChanger.toNormalizedValue(this.getPan()));
    }

    @Override
    public void touchPan(boolean isBeingTouched) {
        this.sender.sendOSC("/master/pan/touch", isBeingTouched ? 1 : 0);
        this.handlePanTouch(isBeingTouched);
    }

    @Override
    public void setIsActivated(boolean value) {
    }

    @Override
    public void toggleIsActivated() {
    }

    @Override
    public void setMute(boolean value) {
        this.setMuteState(value);
        this.sender.sendOSC("/master/mute", value);
    }

    @Override
    public void setSolo(boolean value) {
        this.setSoloState(value);
        this.sender.sendOSC("/master/solo", value);
    }

    @Override
    public void setRecArm(boolean value) {
    }

    @Override
    public void setMonitor(boolean value) {
    }

    @Override
    public void toggleMonitor() {
    }

    @Override
    public void setAutoMonitor(boolean value) {
    }

    @Override
    public void toggleAutoMonitor() {
    }

    @Override
    public void select() {
        this.sender.sendOSC("/master/select", 1);
    }

    @Override
    public void makeVisible() {
    }
}

