/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.reaper.framework.daw.data.ParameterImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public class GrooveParameter
extends ParameterImpl {
    private static final String[] PARAMETER_NAMES = new String[]{"Strgth Position", "Strgth Velocity", "Target", "Sensitivity"};
    private static final String[] PARAMETER_COMMANDS = new String[]{"strength", "velocity", "target", "tolerance"};

    public GrooveParameter(MessageSender sender, IValueChanger valueChanger, int index) {
        super(sender, valueChanger, index);
        this.setName(PARAMETER_NAMES[index]);
    }

    @Override
    public void setValue(double value) {
        if (!this.doesExist()) {
            return;
        }
        int scaledValue = 0;
        block0 : switch (this.index) {
            case 0: 
            case 1: {
                this.value = (int)value;
                scaledValue = (int)Math.round(value * 100.0 / (double)(this.valueChanger.getUpperBound() - 1));
                break;
            }
            case 2: {
                if (value != (double)this.value) {
                    this.value = value < (double)this.value ? 0 : this.valueChanger.getUpperBound() - 1;
                }
                scaledValue = this.value == 0 ? 0 : 1;
                break;
            }
            case 3: {
                this.value = (int)value;
                scaledValue = (int)Math.round(value * 3.0 / (double)(this.valueChanger.getUpperBound() - 1));
                switch (scaledValue) {
                    case 0: {
                        scaledValue = 4;
                        break block0;
                    }
                    case 1: {
                        scaledValue = 8;
                        break block0;
                    }
                    case 2: {
                        scaledValue = 16;
                        break block0;
                    }
                }
                scaledValue = 32;
                break;
            }
        }
        this.sender.sendOSC("/groove/" + PARAMETER_COMMANDS[this.index], scaledValue);
    }

    @Override
    public void resetValue() {
        if (this.index < 2) {
            this.setValue((double)this.valueChanger.getUpperBound() - 1.0);
        } else {
            super.resetValue();
        }
    }
}

