/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.reaper.framework.daw.data.SendImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public class ChannelImpl
extends BaseImpl
implements IChannel {
    protected IValueChanger valueChanger;
    private int index;
    private ChannelType type;
    private boolean selected;
    protected int volume;
    private String volumeStr = "";
    private int vuLeft;
    private int vuRight;
    private String name;
    private String panStr = "";
    protected int pan;
    private boolean isMute;
    private boolean isSolo;
    private boolean isActivated = true;
    private boolean exists;
    private double[] color;
    private ISend[] sends;
    private boolean isVolumeBeingTouched;
    private int lastReceivedVolume = -1;
    private boolean isPanBeingTouched;
    private int lastReceivedPan = -1;

    public ChannelImpl(IHost host, MessageSender sender, IValueChanger valueChanger, int index, int numSends) {
        super(sender, host);
        this.valueChanger = valueChanger;
        this.index = index;
        this.name = "Track " + (index + 1);
        this.sends = new SendImpl[numSends];
        if (numSends == 0) {
            return;
        }
        for (int i = 0; i < numSends; ++i) {
            this.sends[i] = new SendImpl(sender, valueChanger, index, i);
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public ChannelType getType() {
        return this.type == null ? ChannelType.UNKNOWN : this.type;
    }

    @Override
    public boolean isSelected() {
        return this.doesExist() && this.selected;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
    }

    @Override
    public boolean doesExist() {
        return this.exists;
    }

    @Override
    public boolean isActivated() {
        return this.doesExist() && this.isActivated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(int limit) {
        return this.name != null && this.name.length() >= limit ? this.name.substring(0, limit) : this.name;
    }

    @Override
    public String getVolumeStr() {
        return this.doesExist() ? this.volumeStr : "";
    }

    @Override
    public String getVolumeStr(int limit) {
        String vs = this.getVolumeStr();
        return vs.length() > limit ? vs.substring(0, limit) : vs;
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public void changeVolume(int control) {
        this.setVolume(this.valueChanger.changeValue(control, this.getVolume()));
    }

    @Override
    public void setVolume(double value) {
        this.volume = (int)value;
        this.sendTrackOSC("volume", this.valueChanger.toNormalizedValue(this.getVolume()));
    }

    @Override
    public void resetVolume() {
        this.setVolume(0.6 * (double)this.valueChanger.getUpperBound());
    }

    @Override
    public void touchVolume(boolean isBeingTouched) {
        this.sendTrackOSC("volume/touch", isBeingTouched ? 1 : 0);
        this.handleVolumeTouch(isBeingTouched);
    }

    protected void handleVolumeTouch(boolean isBeingTouched) {
        this.isVolumeBeingTouched = isBeingTouched;
        if (this.isVolumeBeingTouched || this.lastReceivedVolume == -1) {
            return;
        }
        this.volume = this.lastReceivedVolume;
        this.lastReceivedVolume = -1;
    }

    @Override
    public void setVolumeIndication(boolean indicate) {
    }

    @Override
    public int getModulatedVolume() {
        return this.getVolume();
    }

    @Override
    public String getPanStr() {
        return this.doesExist() ? this.panStr : "";
    }

    @Override
    public String getPanStr(int limit) {
        String ps = this.getPanStr();
        return ps.length() > limit ? ps.substring(0, limit) : ps;
    }

    @Override
    public int getPan() {
        return this.pan;
    }

    @Override
    public void changePan(int control) {
        this.setPan(this.valueChanger.changeValue(control, this.getPan()));
    }

    @Override
    public void setPan(double value) {
        this.pan = (int)value;
        this.sendTrackOSC("pan", this.valueChanger.toNormalizedValue(this.getPan()));
    }

    @Override
    public void resetPan() {
        this.setPan(0.5 * (double)this.valueChanger.getUpperBound());
    }

    @Override
    public void touchPan(boolean isBeingTouched) {
        this.sendTrackOSC("pan/touch", isBeingTouched ? 1 : 0);
        this.handlePanTouch(isBeingTouched);
    }

    protected void handlePanTouch(boolean isBeingTouched) {
        this.isPanBeingTouched = isBeingTouched;
        if (this.isPanBeingTouched || this.lastReceivedPan == -1) {
            return;
        }
        this.pan = this.lastReceivedPan;
        this.lastReceivedPan = -1;
    }

    @Override
    public void setPanIndication(boolean indicate) {
    }

    @Override
    public int getModulatedPan() {
        return this.getPan();
    }

    @Override
    public double[] getColor() {
        double[] dArray;
        if (this.color == null) {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.2;
            dArray2[1] = 0.2;
            dArray = dArray2;
            dArray2[2] = 0.2;
        } else {
            dArray = this.color;
        }
        return dArray;
    }

    @Override
    public void setColor(double red, double green, double blue) {
        this.sendTrackOSC("color", "RGB(" + Math.round(red * 255.0) + "," + Math.round(green * 255.0) + "," + Math.round(blue * 255.0) + ")");
    }

    @Override
    public boolean isMute() {
        return this.doesExist() && this.isMute;
    }

    @Override
    public boolean isSolo() {
        return this.doesExist() && this.isSolo;
    }

    @Override
    public int getVu() {
        return (this.vuLeft + this.vuRight) / 2;
    }

    @Override
    public int getVuLeft() {
        return this.vuLeft;
    }

    @Override
    public int getVuRight() {
        return this.vuRight;
    }

    @Override
    public int getNumSends() {
        return this.sends.length;
    }

    @Override
    public ISend getSend(int sendIndex) {
        return this.sends[sendIndex];
    }

    @Override
    public void setIsActivated(boolean value) {
        if (value) {
            this.sender.invokeAction(41313);
            this.sender.invokeAction(40536);
            this.sender.invokeAction("_SWS_UNMUTERECVS");
            this.sender.invokeAction("_SWS_UNMUTESENDS");
            this.sender.invokeAction("_S&M_FXBYPALL3");
            this.sender.invokeAction(40731);
        } else {
            this.sender.invokeAction(40730);
            this.sender.invokeAction("_S&M_FXBYPALL2");
            this.sender.invokeAction("_SWS_MUTESENDS");
            this.sender.invokeAction("_SWS_MUTERECVS");
            this.sender.invokeAction(40535);
            this.sender.invokeAction(41312);
        }
    }

    @Override
    public void toggleIsActivated() {
        this.setIsActivated(!this.isActivated);
    }

    @Override
    public void setMute(boolean value) {
        this.setMuteState(value);
        this.sendTrackOSC("mute", value);
    }

    @Override
    public void toggleMute() {
        this.setMute(!this.isMute());
    }

    @Override
    public void setSolo(boolean value) {
        this.setSoloState(value);
        this.sendTrackOSC("solo", value);
    }

    @Override
    public void toggleSolo() {
        this.setSolo(!this.isSolo());
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("ChannelImpl.select not implemented. Only use with TrackImpl!");
    }

    @Override
    public void makeVisible() {
    }

    @Override
    public void selectAndMakeVisible() {
        this.select();
        this.makeVisible();
    }

    public void setType(ChannelType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInternalVolume(int volume) {
        if (this.isVolumeBeingTouched) {
            this.lastReceivedVolume = volume;
        } else {
            this.volume = volume;
        }
    }

    public void setVolumeStr(String volumeStr) {
        this.volumeStr = volumeStr;
    }

    public void setInternalPan(int pan) {
        if (this.isPanBeingTouched) {
            this.lastReceivedPan = pan;
        } else {
            this.pan = pan;
        }
    }

    public void setPanStr(String panStr) {
        this.panStr = panStr;
    }

    public void setVuLeft(int vuLeft) {
        this.vuLeft = vuLeft;
    }

    public void setVuRight(int vuRight) {
        this.vuRight = vuRight;
    }

    public void setMuteState(boolean isMute) {
        this.isMute = isMute;
    }

    public void setSoloState(boolean isSolo) {
        this.isSolo = isSolo;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public void setInternalIsActivated(boolean isActivated) {
        this.isActivated = isActivated;
    }

    public void setColorState(double[] color) {
        this.color = color;
    }

    @Override
    public void duplicate() {
        this.select();
        this.host.scheduleTask(() -> this.sender.invokeAction(40062), 200L);
    }

    protected void sendTrackOSC(String command, Object value) {
        this.sender.sendOSC("/track/" + (this.index + 1) + "/" + command, value);
    }
}

