/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.transformator.communication.MessageSender;
import java.text.DecimalFormat;

public class TransportImpl
extends BaseImpl
implements ITransport {
    private static final int PUNCH_OFF = 0;
    private static final int PUNCH_ITEMS = 1;
    private static final int PUNCH_LOOP = 2;
    private static final double INC_FRACTION_TIME = 1.0;
    private static final double INC_FRACTION_TIME_SLOW = 0.05;
    private ITrackBank trackBank;
    private IValueChanger valueChanger;
    private int crossfade = 0;
    private double position = 0.0;
    private String positionStr = "";
    private double tempo = 120.0;
    private String beatsStr = "";
    private int metroVolume = 512;
    private boolean isMetronomeOn = false;
    private boolean isPlaying = false;
    private boolean isRecording = false;
    private boolean isLooping = false;
    private int numerator = 4;
    private int denominator = 4;
    private boolean prerollClick = false;
    private int preroll = 2;
    private int punchMode = 0;

    public TransportImpl(MessageSender sender, IHost host, ITrackBank trackBank, IValueChanger valueChanger) {
        super(sender, host);
        this.trackBank = trackBank;
        this.valueChanger = valueChanger;
    }

    @Override
    public void play() {
        this.sender.sendOSC("/play", null);
    }

    @Override
    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public void restart() {
    }

    @Override
    public void stop() {
        this.sender.sendOSC("/stop", null);
    }

    @Override
    public void stopAndRewind() {
        this.stop();
        this.sender.sendOSC("/time", 0);
    }

    @Override
    public void record() {
        this.sender.sendOSC("/record", null);
    }

    @Override
    public boolean isRecording() {
        return this.isRecording;
    }

    @Override
    public boolean isArrangerOverdub() {
        return false;
    }

    @Override
    public void toggleOverdub() {
    }

    @Override
    public boolean isLauncherOverdub() {
        return false;
    }

    @Override
    public void setLauncherOverdub(boolean on) {
    }

    @Override
    public void toggleLauncherOverdub() {
    }

    @Override
    public void setMetronome(boolean on) {
        this.isMetronomeOn = on;
    }

    @Override
    public boolean isMetronomeOn() {
        return this.isMetronomeOn;
    }

    @Override
    public void toggleMetronome() {
        this.invokeAction(40364);
    }

    @Override
    public boolean isMetronomeTicksOn() {
        return false;
    }

    @Override
    public void toggleMetronomeTicks() {
    }

    @Override
    public String getMetronomeVolumeStr() {
        return Double.toString(this.metroVolume);
    }

    @Override
    public void changeMetronomeVolume(int control) {
        this.sender.sendOSC("/metro_vol/" + (this.valueChanger.calcKnobSpeed(control) > 0.0 ? (char)'+' : '-'), null);
    }

    @Override
    public void setMetronomeVolume(double value) {
    }

    @Override
    public int getMetronomeVolume() {
        return this.metroVolume;
    }

    @Override
    public boolean isPrerollMetronomeEnabled() {
        return this.prerollClick;
    }

    @Override
    public void togglePrerollMetronome() {
        this.invokeAction(41819);
    }

    @Override
    public String getPreroll() {
        switch (this.preroll) {
            case 0: {
                return "none";
            }
            case 1: {
                return "one_bar";
            }
            case 2: {
                return "two_bars";
            }
            case 4: {
                return "four_bars";
            }
        }
        return "";
    }

    @Override
    public void setPreroll(String preroll) {
        switch (preroll) {
            case "none": {
                this.setPrerollAsBars(0);
                break;
            }
            case "one_bar": {
                this.setPrerollAsBars(1);
                break;
            }
            case "two_bars": {
                this.setPrerollAsBars(2);
                break;
            }
            case "four_bars": {
                this.setPrerollAsBars(4);
                break;
            }
        }
    }

    @Override
    public int getPrerollAsBars() {
        return this.preroll;
    }

    @Override
    public void setPrerollAsBars(int preroll) {
        this.preroll = preroll;
        this.sender.sendOSC("/preroll", preroll);
    }

    @Override
    public void setLoop(boolean on) {
        if (on && !this.isLooping || !on && this.isLooping) {
            this.sender.sendOSC("/repeat", 1);
        }
    }

    @Override
    public void toggleLoop() {
        this.sender.sendOSC("/repeat", 1);
    }

    @Override
    public boolean isLoop() {
        return this.isLooping;
    }

    @Override
    public boolean isWritingClipLauncherAutomation() {
        return false;
    }

    @Override
    public boolean isWritingArrangerAutomation() {
        String automationWriteMode = this.getAutomationWriteMode();
        return automationWriteMode.length() != 0 && !"read".equals(automationWriteMode) && !"trim".equals(automationWriteMode);
    }

    @Override
    public String getAutomationWriteMode() {
        TrackImpl selectedTrack = (TrackImpl)this.trackBank.getSelectedTrack();
        return selectedTrack == null ? "" : selectedTrack.getAutomation();
    }

    @Override
    public void setAutomationWriteMode(String mode) {
        ITrack selectedTrack = this.trackBank.getSelectedTrack();
        if (selectedTrack != null) {
            this.sender.sendOSC("/track/" + (selectedTrack.getIndex() + 1) + "/auto" + mode, 1.0);
        }
    }

    @Override
    public void toggleWriteArrangerAutomation() {
        if (this.isWritingArrangerAutomation()) {
            this.setAutomationWriteMode("read");
        } else {
            this.setAutomationWriteMode("write");
        }
    }

    @Override
    public void toggleWriteClipLauncherAutomation() {
    }

    @Override
    public void resetAutomationOverrides() {
        this.sender.sendOSC("/action_ex", "_S&M_REMOVE_ALLENVS");
    }

    @Override
    public void returnToArrangement() {
    }

    @Override
    public String getPositionText() {
        return this.positionStr;
    }

    @Override
    public String getBeatText() {
        return this.beatsStr;
    }

    @Override
    public void setPosition(double beats) {
        this.position = beats;
    }

    public void setPositionText(String positionStr) {
        this.positionStr = positionStr.replace('.', ':');
    }

    public void setBeats(String beats) {
        this.beatsStr = beats;
    }

    @Override
    public void changePosition(boolean increase) {
        this.changePosition(increase, this.valueChanger.isSlow());
    }

    @Override
    public void changePosition(boolean increase, boolean slow) {
        double frac = slow ? 0.05 : 1.0;
        this.position = increase ? this.position + frac : Math.max(this.position - frac, 0.0);
        this.sender.sendOSC("/time", this.position);
    }

    @Override
    public void togglePunchIn() {
        this.setPunchIn(!this.isPunchInEnabled());
    }

    @Override
    public void setPunchIn(boolean enable) {
        if (enable) {
            this.invokeAction(40076);
            this.punchMode = 2;
        } else {
            this.invokeAction(40252);
            this.punchMode = 0;
        }
    }

    @Override
    public boolean isPunchInEnabled() {
        return this.punchMode != 0;
    }

    @Override
    public void togglePunchOut() {
        this.setPunchOut(!this.isPunchOutEnabled());
    }

    @Override
    public void setPunchOut(boolean enable) {
        if (enable) {
            this.invokeAction(40253);
            this.punchMode = 1;
        } else {
            this.invokeAction(40252);
            this.punchMode = 0;
        }
    }

    @Override
    public boolean isPunchOutEnabled() {
        return this.punchMode != 0;
    }

    @Override
    public void tapTempo() {
        this.invokeAction(1134);
    }

    @Override
    public void changeTempo(boolean increase) {
        boolean isSlow = this.valueChanger.isSlow();
        this.sender.sendOSC("/tempo/" + (increase ? (isSlow ? "+" : "++") : (isSlow ? "-" : "--")), null);
    }

    @Override
    public void setTempo(double tempo) {
        this.tempo = tempo;
    }

    @Override
    public double getTempo() {
        return this.tempo;
    }

    @Override
    public String formatTempo(double tempo) {
        return new DecimalFormat("#.00").format(tempo);
    }

    @Override
    public String formatTempoNoFraction(double tempo) {
        return new DecimalFormat("###").format(tempo);
    }

    @Override
    public void setTempoIndication(boolean isTouched) {
    }

    @Override
    public void setCrossfade(int value) {
    }

    @Override
    public int getCrossfade() {
        return this.crossfade;
    }

    @Override
    public void changeCrossfade(int control) {
    }

    @Override
    public int getNumerator() {
        return this.numerator;
    }

    @Override
    public int getDenominator() {
        return this.denominator;
    }

    @Override
    public int getQuartersPerMeasure() {
        return 4 * this.getNumerator() / this.getDenominator();
    }

    public void setPlayState(boolean isPlaying) {
        this.isPlaying = isPlaying;
    }

    public void setRecordState(boolean isRecording) {
        this.isRecording = isRecording;
    }

    public void setLoopingState(boolean isLooping) {
        this.isLooping = isLooping;
    }

    public void setNumerator(int numerator) {
        this.numerator = numerator;
    }

    public void setDenominator(int denominator) {
        this.denominator = denominator;
    }

    public void setInternalPreroll(int preroll) {
        this.preroll = preroll;
    }

    public void setPrerollClick(boolean enable) {
        this.prerollClick = enable;
    }
}

