/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.AbstractModel;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.reaper.framework.daw.ApplicationImpl;
import de.mossgrabers.reaper.framework.daw.ArrangerImpl;
import de.mossgrabers.reaper.framework.daw.BrowserImpl;
import de.mossgrabers.reaper.framework.daw.CursorClipImpl;
import de.mossgrabers.reaper.framework.daw.CursorDeviceImpl;
import de.mossgrabers.reaper.framework.daw.GrooveImpl;
import de.mossgrabers.reaper.framework.daw.MixerImpl;
import de.mossgrabers.reaper.framework.daw.ProjectImpl;
import de.mossgrabers.reaper.framework.daw.TrackBankImpl;
import de.mossgrabers.reaper.framework.daw.TransportImpl;
import de.mossgrabers.reaper.framework.daw.data.MasterTrackImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public class ModelImpl
extends AbstractModel {
    private MessageSender sender;

    public ModelImpl(MessageSender sender, IHost host, ColorManager colorManager, IValueChanger valueChanger, Scales scales, int numTracks, int numScenes, int numSends, int numFilterColumnEntries, int numResults, boolean hasFlatTrackList, int numParams, int numDevicesInBank, int numDeviceLayers, int numDrumPadLayers) {
        super(colorManager, valueChanger, scales, numTracks, numScenes, numSends, numFilterColumnEntries, numResults, hasFlatTrackList, numParams, numDevicesInBank, numDeviceLayers, numDrumPadLayers);
        this.sender = sender;
        this.host = host;
        this.trackBank = new TrackBankImpl(host, sender, valueChanger, this.numTracks, this.numScenes, this.numSends, this.hasFlatTrackList);
        this.effectTrackBank = null;
        this.masterTrack = new MasterTrackImpl(host, sender, valueChanger);
        this.primaryDevice = new CursorDeviceImpl(sender, host, valueChanger, this.numSends, this.numParams, this.numDevicesInBank, this.numDeviceLayers, this.numDrumPadLayers);
        this.cursorDevice = new CursorDeviceImpl(sender, host, valueChanger, this.numSends, this.numParams, this.numDevicesInBank, this.numDeviceLayers, this.numDrumPadLayers);
        if (this.numDrumPadLayers > 0) {
            this.drumDevice64 = new CursorDeviceImpl(sender, host, valueChanger, 0, 0, 0, 64, 64);
        }
        if (this.numResults > 0) {
            this.browser = new BrowserImpl(sender, this.cursorDevice, this.numFilterColumnEntries, this.numResults);
        }
        this.application = new ApplicationImpl(sender, host);
        this.arranger = new ArrangerImpl();
        this.mixer = new MixerImpl(sender, host);
        this.project = new ProjectImpl(sender);
        this.transport = new TransportImpl(sender, host, this.trackBank, valueChanger);
        this.groove = new GrooveImpl(sender, host, valueChanger);
        this.currentTrackBank = this.trackBank;
    }

    @Override
    public ITrackBank createSceneViewTrackBank(int numTracks, int numScenes) {
        return null;
    }

    @Override
    public ICursorClip getCursorClip(int cols, int rows) {
        return this.cursorClips.computeIfAbsent(cols + "-" + rows, k -> new CursorClipImpl(this.transport, this.sender, this.valueChanger, cols, rows));
    }

    @Override
    public boolean isCursorTrackPinned() {
        return false;
    }

    @Override
    public void toggleCursorTrackPinned() {
    }

    @Override
    public boolean isCursorDeviceOnMasterTrack() {
        return this.getMasterTrack().isSelected();
    }

    @Override
    public boolean canConvertClip() {
        return true;
    }
}

