/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import com.illposed.osc.OSCPortIn;
import com.illposed.osc.OSCPortOut;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMemoryBlock;
import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.framework.graphics.IImage;
import de.mossgrabers.framework.osc.IOpenSoundControlCallback;
import de.mossgrabers.framework.osc.IOpenSoundControlMessage;
import de.mossgrabers.framework.osc.IOpenSoundControlServer;
import de.mossgrabers.framework.usb.IUSBDevice;
import de.mossgrabers.framework.usb.USBMatcher;
import de.mossgrabers.reaper.framework.daw.MemoryBlockImpl;
import de.mossgrabers.reaper.framework.graphics.BitmapImpl;
import de.mossgrabers.reaper.framework.graphics.SVGImage;
import de.mossgrabers.reaper.framework.osc.OpenSoundControlMessageImpl;
import de.mossgrabers.reaper.framework.osc.OpenSoundControlServerImpl;
import de.mossgrabers.reaper.framework.usb.USBDeviceImpl;
import de.mossgrabers.transformator.communication.MessageSender;
import de.mossgrabers.transformator.util.LogModel;
import java.awt.Color;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.stage.Window;

public class HostImpl
implements IHost {
    private final Window owner;
    private final LogModel model;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final List<USBMatcher> usbDeviceInfos = new ArrayList<USBMatcher>();
    private final List<IUSBDevice> usbDevices = new ArrayList<IUSBDevice>();
    private final MessageSender dawSender;
    private OSCPortOut oscSender;
    private OSCPortIn oscReceiver;

    public HostImpl(LogModel model, Window owner, MessageSender sender) {
        this.model = model;
        this.owner = owner;
        this.dawSender = sender;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public String getName() {
        return "Reaper";
    }

    @Override
    public boolean hasClips() {
        return false;
    }

    @Override
    public boolean hasPinning() {
        return false;
    }

    @Override
    public boolean hasCrossfader() {
        return false;
    }

    @Override
    public boolean hasDrumDevice() {
        return false;
    }

    @Override
    public boolean hasRepeat() {
        return true;
    }

    @Override
    public void scheduleTask(Runnable task, long delay) {
        try {
            this.executor.schedule(task, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            this.error("Could not delay thread.", ex);
        }
    }

    @Override
    public void error(String text) {
        this.model.addLogMessage(text);
    }

    @Override
    public void error(String text, Exception ex) {
        this.model.addLogMessage(text);
        this.model.addLogMessage(ex.getClass() + ":" + ex.getMessage());
    }

    @Override
    public void println(String text) {
        this.model.addLogMessage(text);
    }

    @Override
    public void showNotification(String message) {
        this.dawSender.sendOSC("/notify", message);
    }

    @Override
    public IImage loadSVG(String imageName, int scale) {
        String filename = "/images/" + imageName;
        try {
            return SVGImage.getSVGImage(filename, Color.BLACK);
        }
        catch (IOException ex) {
            this.error("Could not load SVG image: " + filename, ex);
            return null;
        }
    }

    @Override
    public IBitmap createBitmap(int width, int height) {
        return new BitmapImpl(this.owner, width, height);
    }

    @Override
    public IMemoryBlock createMemoryBlock(int size) {
        return new MemoryBlockImpl(size);
    }

    @Override
    public IUSBDevice getUsbDevice(int index) {
        USBDeviceImpl usbDevice = new USBDeviceImpl(this, this.usbDeviceInfos.get(index));
        this.usbDevices.add(usbDevice);
        return usbDevice;
    }

    @Override
    public void releaseUsbDevices() {
        for (IUSBDevice usbDevice : this.usbDevices) {
            usbDevice.release();
        }
    }

    public void addUSBDeviceInfo(USBMatcher matcher) {
        this.usbDeviceInfos.add(matcher);
    }

    @Override
    public IOpenSoundControlServer connectToOSCServer(String serverAddress, int serverPort) {
        try {
            if (this.oscSender != null) {
                this.oscSender.close();
            }
            this.oscSender = new OSCPortOut(InetAddress.getByName(serverAddress), serverPort);
            return new OpenSoundControlServerImpl(this.oscSender);
        }
        catch (SocketException | UnknownHostException ex) {
            this.error("Could not connect to OSC server.", ex);
            return new OpenSoundControlServerImpl(null);
        }
    }

    @Override
    public void createOSCServer(IOpenSoundControlCallback callback, int port) {
        try {
            if (this.oscReceiver != null) {
                this.oscReceiver.stopListening();
                this.oscReceiver.close();
            }
            this.oscReceiver = new OSCPortIn(port);
        }
        catch (SocketException ex) {
            this.error("Could not create OSC server.", ex);
            return;
        }
        this.oscReceiver.addListener(messageAddress -> true, (time, message) -> Platform.runLater(() -> callback.handle(new OpenSoundControlMessageImpl(message))));
        this.oscReceiver.startListening();
    }

    @Override
    public IOpenSoundControlMessage createOSCMessage(String address, List<Object> values) {
        return new OpenSoundControlMessageImpl(address, values);
    }

    @Override
    public void releaseOSC() {
        if (this.oscReceiver != null) {
            this.oscReceiver.stopListening();
            this.oscReceiver.close();
        }
        if (this.oscSender != null) {
            this.oscSender.close();
        }
    }
}

