/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.reaper.framework.daw.data.GrooveParameter;
import de.mossgrabers.reaper.framework.daw.data.ParameterImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public class GrooveImpl
extends BaseImpl
implements IGroove {
    private final ParameterImpl[] parameters = new ParameterImpl[4];
    private IValueChanger valueChanger;

    public GrooveImpl(MessageSender sender, IHost host, IValueChanger valueChanger) {
        super(sender, host);
        this.valueChanger = valueChanger;
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = new GrooveParameter(sender, valueChanger, i);
        }
    }

    @Override
    public IParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public void setIndication(boolean enable) {
    }

    public void setParameter(int index, int value) {
        block0 : switch (index) {
            case 0: 
            case 1: {
                this.parameters[index].setInternalValue(value * (this.valueChanger.getUpperBound() - 1) / 100);
                this.parameters[index].setValueStr(value + "%");
                break;
            }
            case 2: {
                this.parameters[index].setInternalValue(value == 0 ? 0 : this.valueChanger.getUpperBound() - 1);
                this.parameters[index].setValueStr(value == 0 ? "Items" : "Notes");
                break;
            }
            case 3: {
                switch (value) {
                    case 4: {
                        this.parameters[index].setInternalValue(0);
                        this.parameters[index].setValueStr("4th");
                        break block0;
                    }
                    case 8: {
                        this.parameters[index].setInternalValue((this.valueChanger.getUpperBound() - 1) / 3);
                        this.parameters[index].setValueStr("8th");
                        break block0;
                    }
                    case 16: {
                        this.parameters[index].setInternalValue(2 * (this.valueChanger.getUpperBound() - 1) / 3);
                        this.parameters[index].setValueStr("16th");
                        break block0;
                    }
                }
                this.parameters[index].setInternalValue(this.valueChanger.getUpperBound() - 1);
                this.parameters[index].setValueStr("32nd");
                break;
            }
        }
    }
}

