/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.reaper.framework.daw.data.DrumPadImpl;
import de.mossgrabers.reaper.framework.daw.data.ParameterImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public class CursorDeviceImpl
extends BaseImpl
implements ICursorDevice {
    private int numParams;
    private int numDevicesInBank;
    private int numDeviceLayers;
    private int numDrumPadLayers;
    private boolean exists = false;
    private boolean isEnabled = false;
    private String name;
    private int position;
    private boolean isWindowOpen;
    private boolean isExpanded;
    private String[] siblings;
    private IParameter[] fxparams;
    private IDrumPad[] drumPadLayers;
    private int selectedDevice = 0;
    private int selectedParameterPage = 0;
    private int selectedParameterBank = 0;
    private int deviceCount = 0;
    private String[] parameterPageNames = new String[0];

    public CursorDeviceImpl(MessageSender sender, IHost host, IValueChanger valueChanger, int numSends, int numParams, int numDevicesInBank, int numDeviceLayers, int numDrumPadLayers) {
        super(sender, host);
        int i;
        this.numParams = numParams >= 0 ? numParams : 8;
        this.numDevicesInBank = numDevicesInBank >= 0 ? numDevicesInBank : 8;
        this.numDeviceLayers = numDeviceLayers >= 0 ? numDeviceLayers : 8;
        int n = this.numDrumPadLayers = numDrumPadLayers >= 0 ? numDrumPadLayers : 16;
        if (this.numDevicesInBank > 0) {
            this.siblings = new String[this.numDevicesInBank];
            for (i = 0; i < this.numDevicesInBank; ++i) {
                this.siblings[i] = "";
            }
        }
        if (this.numParams > 0) {
            this.fxparams = new IParameter[this.numParams];
            for (i = 0; i < this.numParams; ++i) {
                this.fxparams[i] = new ParameterImpl(sender, valueChanger, i);
            }
        }
        if (this.numDrumPadLayers > 0) {
            this.drumPadLayers = new IDrumPad[this.numDrumPadLayers];
            for (i = 0; i < this.numDrumPadLayers; ++i) {
                this.drumPadLayers[i] = new DrumPadImpl(host, sender, valueChanger, i, numSends);
            }
        }
    }

    @Override
    public void browseToReplaceDevice() {
    }

    @Override
    public void browseToInsertBeforeDevice() {
    }

    @Override
    public void browseToInsertAfterDevice() {
    }

    @Override
    public void selectParent() {
    }

    @Override
    public void selectChannel() {
    }

    @Override
    public boolean doesExist() {
        return this.exists;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public String getName(int limit) {
        String n = this.getName();
        if (n.length() < limit) {
            return n;
        }
        String[] split = n.split(": ");
        if (split.length == 2) {
            n = split[1];
        }
        if (n.length() < limit) {
            return n;
        }
        return n.substring(0, limit);
    }

    @Override
    public boolean isPlugin() {
        return true;
    }

    @Override
    public int getPositionInChain() {
        return this.position;
    }

    @Override
    public int getPositionInBank() {
        return this.selectedDevice;
    }

    @Override
    public boolean canSelectPreviousFX() {
        return this.selectedDevice > 0;
    }

    @Override
    public boolean canSelectNextFX() {
        return this.position < this.deviceCount - 1;
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public boolean isParameterPageSectionVisible() {
        return true;
    }

    @Override
    public boolean isWindowOpen() {
        return this.isWindowOpen;
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public boolean hasDrumPads() {
        return false;
    }

    @Override
    public boolean hasLayers() {
        return false;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean isPinned() {
        return false;
    }

    @Override
    public void togglePinned() {
    }

    @Override
    public void changeParameter(int index, int control) {
        this.getFXParam(index).changeValue(control);
    }

    @Override
    public void setParameter(int index, int value) {
        this.getFXParam(index).setValue(value);
    }

    @Override
    public void resetParameter(int index) {
        this.getFXParam(index).resetValue();
    }

    @Override
    public void indicateParameter(int index, boolean indicate) {
        this.getFXParam(index).setIndication(indicate);
    }

    @Override
    public void touchParameter(int index, boolean indicate) {
        this.getFXParam(index).touchValue(indicate);
    }

    @Override
    public void previousParameterPage() {
        if (this.selectedParameterPage > 0) {
            --this.selectedParameterPage;
            this.sender.sendOSC("/device/param/-", null);
        }
    }

    @Override
    public void nextParameterPage() {
        if (this.selectedParameterPage < this.parameterPageNames.length - 1) {
            ++this.selectedParameterPage;
            this.sender.sendOSC("/device/param/+", null);
        }
    }

    @Override
    public void setSelectedParameterPage(int index) {
        this.selectedParameterPage = index;
        this.selectedParameterBank = this.selectedParameterPage / this.numDevicesInBank;
    }

    @Override
    public int getSelectedParameterPage() {
        return this.selectedParameterPage;
    }

    @Override
    public boolean hasPreviousParameterPage() {
        return this.selectedParameterPage > 0;
    }

    @Override
    public boolean hasNextParameterPage() {
        return this.selectedParameterPage < this.parameterPageNames.length - 1;
    }

    @Override
    public String[] getParameterPageNames() {
        return this.parameterPageNames;
    }

    @Override
    public String getSelectedParameterPageName() {
        int sel = this.getSelectedParameterPage();
        return sel >= 0 && sel < this.parameterPageNames.length ? this.parameterPageNames[sel] : "";
    }

    @Override
    public void setSelectedParameterPageInBank(int index) {
        this.selectedParameterPage = this.selectedParameterBank * 8 + index;
        this.sender.sendOSC("/device/param/bank/selected", this.selectedParameterPage + 1);
    }

    @Override
    public void previousParameterPageBank() {
        this.sender.sendOSC("/device/param/bank/-", null);
    }

    @Override
    public void nextParameterPageBank() {
        this.sender.sendOSC("/device/param/bank/+", null);
    }

    @Override
    public void toggleEnabledState() {
        this.sender.sendOSC("/device/bypass", this.isEnabled ? 1 : 0);
    }

    @Override
    public void toggleWindowOpen() {
        this.sender.sendOSC("/device/window", this.isWindowOpen ? 0 : 1);
    }

    @Override
    public void selectPrevious() {
        if (this.selectedDevice > 0) {
            this.name = this.siblings[this.selectedDevice - 1];
        }
        this.sender.sendOSC("/device/-", null);
    }

    @Override
    public void selectNext() {
        if (this.selectedDevice < this.numDevicesInBank - 1) {
            this.name = this.siblings[this.selectedDevice + 1];
        }
        this.sender.sendOSC("/device/+", null);
    }

    @Override
    public boolean doesSiblingExist(int index) {
        return !this.siblings[index].isEmpty();
    }

    @Override
    public String getSiblingDeviceName(int index) {
        return this.siblings[index];
    }

    @Override
    public String getSiblingDeviceName(int index, int limit) {
        String sibling = this.siblings[index];
        return sibling != null && sibling.length() >= limit ? sibling.substring(0, limit) : sibling;
    }

    @Override
    public void selectSibling(int index) {
        this.selectedDevice = index;
        this.sender.sendOSC("/device/selected", index + 1);
    }

    @Override
    public void selectPreviousBank() {
        this.sender.sendOSC("/device/page/-", null);
    }

    @Override
    public void selectNextBank() {
        this.sender.sendOSC("/device/page/+", null);
    }

    @Override
    public boolean hasSelectedDevice() {
        return this.doesExist();
    }

    @Override
    public IParameter getFXParam(int index) {
        return this.fxparams[index];
    }

    @Override
    public void toggleExpanded() {
        this.isExpanded = !this.isExpanded;
        this.sender.sendOSC("/device/expand", this.isExpanded ? 1 : 0);
    }

    @Override
    public void toggleParameterPageSectionVisible() {
    }

    @Override
    public IChannel getLayerOrDrumPad(int index) {
        return this.hasDrumPads() ? this.getDrumPad(index) : this.getLayer(index);
    }

    @Override
    public IChannel getSelectedLayerOrDrumPad() {
        return this.hasDrumPads() ? this.getSelectedDrumPad() : this.getSelectedLayer();
    }

    @Override
    public void selectLayerOrDrumPad(int index) {
        if (this.hasDrumPads()) {
            this.selectDrumPad(index);
        } else {
            this.selectLayer(index);
        }
    }

    @Override
    public void previousLayerOrDrumPad() {
        if (this.hasDrumPads()) {
            this.previousDrumPad();
        } else {
            this.previousLayer();
        }
    }

    @Override
    public void nextLayerOrDrumPad() {
        if (this.hasDrumPads()) {
            this.nextDrumPad();
        } else {
            this.nextLayer();
        }
    }

    @Override
    public void previousLayerOrDrumPadBank() {
        if (this.hasDrumPads()) {
            this.previousDrumPadBank();
        } else {
            this.previousLayerBank();
        }
    }

    @Override
    public void nextLayerOrDrumPadBank() {
        if (this.hasDrumPads()) {
            this.nextDrumPadBank();
        } else {
            this.nextLayerBank();
        }
    }

    @Override
    public void enterLayerOrDrumPad(int index) {
        if (this.hasDrumPads()) {
            this.enterDrumPad(index);
        } else {
            this.enterLayer(index);
        }
    }

    @Override
    public void selectFirstDeviceInLayerOrDrumPad(int index) {
        if (this.hasDrumPads()) {
            this.selectFirstDeviceInDrumPad(index);
        } else {
            this.selectFirstDeviceInLayer(index);
        }
    }

    @Override
    public boolean canScrollLayersOrDrumPadsUp() {
        return this.hasDrumPads() ? this.canScrollDrumPadsUp() : this.canScrollLayersUp();
    }

    @Override
    public boolean canScrollLayersOrDrumPadsDown() {
        return this.hasDrumPads() ? this.canScrollDrumPadsDown() : this.canScrollLayersDown();
    }

    @Override
    public void scrollLayersOrDrumPadsPageUp() {
        if (this.hasDrumPads()) {
            this.scrollDrumPadsPageUp();
        } else {
            this.scrollLayersPageUp();
        }
    }

    @Override
    public void scrollLayersOrDrumPadsPageDown() {
        if (this.hasDrumPads()) {
            this.scrollDrumPadsPageDown();
        } else {
            this.scrollLayersPageDown();
        }
    }

    @Override
    public void setLayerOrDrumPadColor(int index, double red, double green, double blue) {
        if (this.hasDrumPads()) {
            this.setDrumPadColor(index, red, green, blue);
        } else {
            this.setLayerColor(index, red, green, blue);
        }
    }

    @Override
    public String getLayerOrDrumPadColorEntry(int index) {
        return DAWColors.getColorIndex(this.getLayerOrDrumPad(index).getColor());
    }

    @Override
    public void changeLayerOrDrumPadVolume(int index, int control) {
        if (this.hasDrumPads()) {
            this.changeDrumPadVolume(index, control);
        } else {
            this.changeLayerVolume(index, control);
        }
    }

    @Override
    public void setLayerOrDrumPadVolume(int index, int value) {
        if (this.hasDrumPads()) {
            this.setDrumPadVolume(index, value);
        } else {
            this.setLayerVolume(index, value);
        }
    }

    @Override
    public void resetLayerOrDrumPadVolume(int index) {
        if (this.hasDrumPads()) {
            this.resetDrumPadVolume(index);
        } else {
            this.resetLayerVolume(index);
        }
    }

    @Override
    public void touchLayerOrDrumPadVolume(int index, boolean isBeingTouched) {
        if (this.hasDrumPads()) {
            this.touchDrumPadVolume(index, isBeingTouched);
        } else {
            this.touchLayerVolume(index, isBeingTouched);
        }
    }

    @Override
    public void changeLayerOrDrumPadPan(int index, int control) {
        if (this.hasDrumPads()) {
            this.changeDrumPadPan(index, control);
        } else {
            this.changeLayerPan(index, control);
        }
    }

    @Override
    public void setLayerOrDrumPadPan(int index, int value) {
        if (this.hasDrumPads()) {
            this.setDrumPadPan(index, value);
        } else {
            this.setLayerPan(index, value);
        }
    }

    @Override
    public void resetLayerOrDrumPadPan(int index) {
        if (this.hasDrumPads()) {
            this.resetDrumPadPan(index);
        } else {
            this.resetLayerPan(index);
        }
    }

    @Override
    public void touchLayerOrDrumPadPan(int index, boolean isBeingTouched) {
        if (this.hasDrumPads()) {
            this.touchDrumPadPan(index, isBeingTouched);
        } else {
            this.touchLayerPan(index, isBeingTouched);
        }
    }

    @Override
    public void changeLayerOrDrumPadSend(int index, int send, int control) {
        if (this.hasDrumPads()) {
            this.changeDrumPadSend(index, send, control);
        } else {
            this.changeLayerSend(index, send, control);
        }
    }

    @Override
    public void setLayerOrDrumPadSend(int index, int send, int value) {
        if (this.hasDrumPads()) {
            this.setDrumPadSend(index, send, value);
        } else {
            this.setLayerSend(index, send, value);
        }
    }

    @Override
    public void resetLayerOrDrumPadSend(int index, int send) {
        if (this.hasDrumPads()) {
            this.resetDrumPadSend(index, send);
        } else {
            this.resetLayerSend(index, send);
        }
    }

    @Override
    public void touchLayerOrDrumPadSend(int index, int send, boolean isBeingTouched) {
        if (this.hasDrumPads()) {
            this.touchDrumPadSend(index, send, isBeingTouched);
        } else {
            this.touchLayerSend(index, send, isBeingTouched);
        }
    }

    @Override
    public void toggleLayerOrDrumPadIsActivated(int index) {
        if (this.hasDrumPads()) {
            this.toggleDrumPadIsActivated(index);
        } else {
            this.toggleLayerIsActivated(index);
        }
    }

    @Override
    public void toggleLayerOrDrumPadMute(int index) {
        if (this.hasDrumPads()) {
            this.toggleDrumPadMute(index);
        } else {
            this.toggleLayerMute(index);
        }
    }

    @Override
    public void setLayerOrDrumPadMute(int index, boolean value) {
        if (this.hasDrumPads()) {
            this.setDrumPadMute(index, value);
        } else {
            this.setLayerMute(index, value);
        }
    }

    @Override
    public void toggleLayerOrDrumPadSolo(int index) {
        if (this.hasDrumPads()) {
            this.toggleDrumPadSolo(index);
        } else {
            this.toggleLayerSolo(index);
        }
    }

    @Override
    public void setLayerOrDrumPadSolo(int index, boolean value) {
        if (this.hasDrumPads()) {
            this.setDrumPadSolo(index, value);
        } else {
            this.setLayerSolo(index, value);
        }
    }

    @Override
    public boolean hasZeroLayers() {
        return true;
    }

    @Override
    public IChannel getLayer(int index) {
        return null;
    }

    @Override
    public IChannel getSelectedLayer() {
        return null;
    }

    @Override
    public void selectLayer(int index) {
    }

    @Override
    public void previousLayer() {
    }

    @Override
    public void nextLayer() {
    }

    @Override
    public void previousLayerBank() {
    }

    @Override
    public void nextLayerBank() {
    }

    @Override
    public void enterLayer(int index) {
    }

    @Override
    public void selectFirstDeviceInLayer(int index) {
    }

    @Override
    public boolean canScrollLayersUp() {
        return false;
    }

    @Override
    public boolean canScrollLayersDown() {
        return false;
    }

    @Override
    public void scrollLayersPageUp() {
    }

    @Override
    public void scrollLayersPageDown() {
    }

    @Override
    public void setLayerColor(int index, double red, double green, double blue) {
    }

    @Override
    public void changeLayerVolume(int index, int control) {
    }

    @Override
    public void setLayerVolume(int index, int value) {
    }

    @Override
    public void resetLayerVolume(int index) {
    }

    @Override
    public void touchLayerVolume(int index, boolean isBeingTouched) {
    }

    @Override
    public void changeLayerPan(int index, int control) {
    }

    @Override
    public void setLayerPan(int index, int value) {
    }

    @Override
    public void resetLayerPan(int index) {
    }

    @Override
    public void touchLayerPan(int index, boolean isBeingTouched) {
    }

    @Override
    public void changeLayerSend(int index, int sendIndex, int control) {
    }

    @Override
    public void setLayerSend(int index, int sendIndex, int value) {
    }

    @Override
    public void resetLayerSend(int index, int sendIndex) {
    }

    @Override
    public void touchLayerSend(int index, int sendIndex, boolean isBeingTouched) {
    }

    @Override
    public void toggleLayerIsActivated(int index) {
    }

    @Override
    public void toggleLayerMute(int index) {
    }

    @Override
    public void setLayerMute(int index, boolean value) {
    }

    @Override
    public void toggleLayerSolo(int index) {
    }

    @Override
    public void setLayerSolo(int index, boolean value) {
    }

    @Override
    public void setDrumPadIndication(boolean enable) {
    }

    @Override
    public IDrumPad getDrumPad(int index) {
        return this.drumPadLayers[index];
    }

    @Override
    public IChannel getSelectedDrumPad() {
        return null;
    }

    @Override
    public void selectDrumPad(int index) {
    }

    @Override
    public void previousDrumPad() {
    }

    @Override
    public void nextDrumPad() {
    }

    @Override
    public void previousDrumPadBank() {
    }

    @Override
    public void nextDrumPadBank() {
    }

    @Override
    public void enterDrumPad(int index) {
    }

    @Override
    public void selectFirstDeviceInDrumPad(int index) {
    }

    @Override
    public boolean canScrollDrumPadsUp() {
        return this.canScrollLayersUp();
    }

    @Override
    public boolean canScrollDrumPadsDown() {
        return this.canScrollLayersDown();
    }

    @Override
    public void scrollDrumPadsPageUp() {
    }

    @Override
    public void scrollDrumPadsPageDown() {
    }

    @Override
    public void scrollDrumPadsUp() {
    }

    @Override
    public void scrollDrumPadsDown() {
    }

    @Override
    public void setDrumPadColor(int index, double red, double green, double blue) {
    }

    @Override
    public void changeDrumPadVolume(int index, int control) {
    }

    @Override
    public void setDrumPadVolume(int index, int value) {
    }

    @Override
    public void resetDrumPadVolume(int index) {
    }

    @Override
    public void touchDrumPadVolume(int index, boolean isBeingTouched) {
    }

    @Override
    public void changeDrumPadPan(int index, int control) {
    }

    @Override
    public void setDrumPadPan(int index, int value) {
    }

    @Override
    public void resetDrumPadPan(int index) {
    }

    @Override
    public void touchDrumPadPan(int index, boolean isBeingTouched) {
    }

    @Override
    public void changeDrumPadSend(int index, int sendIndex, int control) {
    }

    @Override
    public void setDrumPadSend(int index, int sendIndex, int value) {
    }

    @Override
    public void resetDrumPadSend(int index, int sendIndex) {
    }

    @Override
    public void touchDrumPadSend(int index, int sendIndex, boolean isBeingTouched) {
    }

    @Override
    public void toggleDrumPadIsActivated(int index) {
    }

    @Override
    public void toggleDrumPadMute(int index) {
    }

    @Override
    public void setDrumPadMute(int index, boolean value) {
    }

    @Override
    public void toggleDrumPadSolo(int index) {
    }

    @Override
    public void setDrumPadSolo(int index, boolean value) {
    }

    @Override
    public int getNumLayers() {
        return this.numDeviceLayers;
    }

    @Override
    public int getNumParameters() {
        return this.numParams;
    }

    @Override
    public int getNumDevices() {
        return this.numDevicesInBank;
    }

    @Override
    public int getNumDrumPads() {
        return this.numDrumPadLayers;
    }

    public void setPosition(int position) {
        this.position = position;
        this.selectedDevice = position % this.getNumDevices();
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public void setWindowOpen(boolean isWindowOpen) {
        this.isWindowOpen = isWindowOpen;
    }

    public void setSiblingDeviceName(int index, String name) {
        this.siblings[index] = CursorDeviceImpl.removeTypeAndManufacturer(name);
    }

    public void setDeviceCount(int deviceCount) {
        this.deviceCount = deviceCount;
    }

    public void setParameterCount(int count) {
        int numOfPages = count / this.numDevicesInBank + (count % this.numDevicesInBank > 0 ? 1 : 0);
        this.parameterPageNames = new String[numOfPages];
        for (int i = 0; i < numOfPages; ++i) {
            this.parameterPageNames[i] = "Page " + (i + 1);
        }
    }

    private static String removeTypeAndManufacturer(String name) {
        if (name == null) {
            return "";
        }
        if (name.startsWith("VSTi: ")) {
            return CursorDeviceImpl.removeManufacturer(name.substring(6));
        }
        if (name.startsWith("VST: ")) {
            return CursorDeviceImpl.removeManufacturer(name.substring(5));
        }
        if (name.startsWith("VST3i: ")) {
            return CursorDeviceImpl.removeManufacturer(name.substring(7));
        }
        if (name.startsWith("VST3: ")) {
            return CursorDeviceImpl.removeManufacturer(name.substring(6));
        }
        if (name.startsWith("JS: ")) {
            return CursorDeviceImpl.removeManufacturer(name.substring(4));
        }
        return name;
    }

    private static String removeManufacturer(String name) {
        int index = name.indexOf(40);
        return index > 1 ? name.substring(0, index).trim() : name;
    }
}

