/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public class CursorClipImpl
extends BaseImpl
implements ICursorClip {
    private ITransport transport;
    private IValueChanger valueChanger;
    private int numSteps;
    private int numRows;
    private double clipStart = -1.0;
    private double clipEnd = -1.0;

    public CursorClipImpl(ITransport transport, MessageSender sender, IValueChanger valueChanger, int numSteps, int numRows) {
        super(sender, null);
        this.transport = transport;
        this.valueChanger = valueChanger;
        this.numSteps = numSteps;
        this.numRows = numRows;
    }

    @Override
    public void setColor(double red, double green, double blue) {
        this.sendClipOSC("color", "RGB(" + Math.round(red * 255.0) + "," + Math.round(green * 255.0) + "," + Math.round(blue * 255.0) + ")");
    }

    @Override
    public double[] getColor() {
        return new double[]{0.0, 0.0, 0.0};
    }

    @Override
    public double getPlayStart() {
        return this.clipStart;
    }

    @Override
    public void setPlayStart(double start) {
        this.clipStart = start;
    }

    @Override
    public void changePlayStart(int control) {
        if (this.clipStart == -1.0) {
            return;
        }
        this.clipStart = Math.max(0.0, this.clipStart + this.valueChanger.calcKnobSpeed(control, this.valueChanger.isSlow() ? 0.1 : 1.0));
        this.sendClipOSC("start", this.clipStart);
    }

    @Override
    public double getPlayEnd() {
        return this.clipEnd;
    }

    @Override
    public void setPlayEnd(double end) {
        this.clipEnd = end;
    }

    @Override
    public void changePlayEnd(int control) {
        if (this.clipEnd == -1.0) {
            return;
        }
        double speed = this.valueChanger.calcKnobSpeed(control, this.valueChanger.isSlow() ? 0.1 : 1.0);
        this.clipEnd = Math.max(0.0, this.clipEnd + speed);
        this.sendClipOSC("end", this.clipEnd);
    }

    @Override
    public void setPlayRange(double start, double end) {
        this.setPlayStart(start);
        this.setPlayEnd(end);
        this.sendClipOSC("start", this.clipStart);
        this.sendClipOSC("end", this.clipEnd);
    }

    @Override
    public double getLoopStart() {
        return this.getPlayStart();
    }

    @Override
    public void setLoopStart(double start) {
        this.setPlayStart(start);
    }

    @Override
    public void changeLoopStart(int control) {
        this.changePlayStart(control);
    }

    @Override
    public double getLoopLength() {
        return this.getPlayEnd() - this.getPlayStart();
    }

    @Override
    public void setLoopLength(int length) {
        this.setPlayEnd(this.getPlayStart() + (double)length);
    }

    @Override
    public void changeLoopLength(int control) {
        this.changePlayEnd(control);
    }

    @Override
    public boolean isLoopEnabled() {
        return this.transport.isLoop();
    }

    @Override
    public void setLoopEnabled(boolean enable) {
        this.transport.setLoop(enable);
    }

    @Override
    public boolean isShuffleEnabled() {
        return false;
    }

    @Override
    public void setShuffleEnabled(boolean enable) {
    }

    @Override
    public String getFormattedAccent() {
        return Math.round(this.getAccent() * 10000.0) / 100L + "%";
    }

    @Override
    public double getAccent() {
        return 1.0;
    }

    @Override
    public void resetAccent() {
    }

    @Override
    public void changeAccent(int control) {
    }

    @Override
    public int getNumSteps() {
        return this.numSteps;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getCurrentStep() {
        return 0;
    }

    @Override
    public int getStep(int step, int row) {
        return 0;
    }

    @Override
    public void toggleStep(int step, int row, int velocity) {
    }

    @Override
    public void setStep(int step, int row, int velocity, double duration) {
    }

    @Override
    public void clearStep(int step, int row) {
    }

    @Override
    public void clearRow(int row) {
    }

    @Override
    public boolean hasRowData(int row) {
        return false;
    }

    @Override
    public int getLowerRowWithData() {
        return -1;
    }

    @Override
    public int getUpperRowWithData() {
        return -1;
    }

    @Override
    public void setStepLength(double length) {
    }

    @Override
    public double getStepLength() {
        return 1.0;
    }

    @Override
    public void scrollTo(int step, int row) {
    }

    @Override
    public void scrollToPage(int page) {
    }

    @Override
    public int getEditPage() {
        return 0;
    }

    @Override
    public void scrollStepsPageBackwards() {
    }

    @Override
    public void scrollStepsPageForward() {
    }

    @Override
    public boolean canScrollStepsBackwards() {
        return false;
    }

    @Override
    public boolean canScrollStepsForwards() {
        return false;
    }

    @Override
    public void duplicate() {
        this.invokeAction(41295);
    }

    @Override
    public void duplicateContent() {
        this.invokeAction(41295);
        this.invokeAction("_SWS_ADDLEFTITEM");
        this.invokeAction(41588);
    }

    @Override
    public void quantize(double amount) {
        this.sender.sendOSC("/quantize", null);
    }

    @Override
    public void transpose(int semitones) {
    }

    protected void sendClipOSC(String command, Object value) {
        this.sender.sendOSC("/clip/" + command + "/", value);
    }
}

