/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.daw.AbstractBrowser;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.framework.device.Device;
import de.mossgrabers.reaper.framework.device.DeviceCollection;
import de.mossgrabers.reaper.framework.device.DeviceFileType;
import de.mossgrabers.reaper.framework.device.DeviceLocation;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.DeviceType;
import de.mossgrabers.reaper.framework.device.column.DeviceCategoryFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceCollectionFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceCreatorFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceFileTypeFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceLocationFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceTagsFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceTypeFilterColumn;
import de.mossgrabers.reaper.framework.device.column.EmptyFilterColumn;
import de.mossgrabers.transformator.communication.MessageSender;
import java.util.Collections;
import java.util.List;

public class BrowserImpl
extends AbstractBrowser {
    private static final String[] CONTENT_TYPE_NAMES = new String[]{"Devices", "Presets"};
    private ContentType contentType = ContentType.CONTENTTYPE_PRESET;
    final DeviceCollectionFilterColumn deviceCollectionFilterColumn;
    final DeviceLocationFilterColumn deviceLocationFilterColumn;
    final DeviceFileTypeFilterColumn deviceFileTypeFilterColumn;
    final DeviceCategoryFilterColumn deviceCategoryFilterColumn;
    final DeviceTagsFilterColumn deviceTagsFilterColumn;
    final DeviceCreatorFilterColumn deviceCreatorFilterColumn;
    final DeviceTypeFilterColumn deviceTypeFilterColumn;
    private boolean isBrowserActive;
    String[] presets = new String[128];
    private int presetCount = 0;
    int selectedIndex;
    List<Device> filteredDevices = Collections.emptyList();
    private MessageSender sender;
    private IBrowserColumn[][] columnDataContentTypes;
    private int insertPosition;

    public BrowserImpl(MessageSender sender, ICursorDevice cursorDevice, int numFilterColumnEntries, int numResults) {
        super(cursorDevice, numFilterColumnEntries, numResults);
        this.sender = sender;
        this.deviceCollectionFilterColumn = new DeviceCollectionFilterColumn(0, numFilterColumnEntries);
        this.deviceLocationFilterColumn = new DeviceLocationFilterColumn(1, numFilterColumnEntries);
        this.deviceFileTypeFilterColumn = new DeviceFileTypeFilterColumn(2, numFilterColumnEntries);
        this.deviceCategoryFilterColumn = new DeviceCategoryFilterColumn(3, numFilterColumnEntries);
        this.deviceTagsFilterColumn = new DeviceTagsFilterColumn(4, numFilterColumnEntries);
        this.deviceCreatorFilterColumn = new DeviceCreatorFilterColumn(5, numFilterColumnEntries);
        this.deviceTypeFilterColumn = new DeviceTypeFilterColumn(6, numFilterColumnEntries);
        this.columnDataContentTypes = new IBrowserColumn[2][];
        this.columnDataContentTypes[ContentType.CONTENTTYPE_DEVICE.ordinal()] = new IBrowserColumn[]{this.deviceCollectionFilterColumn, this.deviceLocationFilterColumn, this.deviceFileTypeFilterColumn, this.deviceCategoryFilterColumn, this.deviceTagsFilterColumn, this.deviceCreatorFilterColumn, this.deviceTypeFilterColumn};
        this.columnDataContentTypes[ContentType.CONTENTTYPE_PRESET.ordinal()] = new IBrowserColumn[]{new EmptyFilterColumn(0, numFilterColumnEntries), new EmptyFilterColumn(1, numFilterColumnEntries), new EmptyFilterColumn(2, numFilterColumnEntries), new EmptyFilterColumn(3, numFilterColumnEntries), new EmptyFilterColumn(4, numFilterColumnEntries), new EmptyFilterColumn(5, numFilterColumnEntries), new EmptyFilterColumn(6, numFilterColumnEntries), new EmptyFilterColumn(7, numFilterColumnEntries)};
        this.columnData = this.columnDataContentTypes[ContentType.CONTENTTYPE_PRESET.ordinal()];
        this.resultData = this.createResultData(this.numResults);
    }

    @Override
    public void enableObservers(boolean enable) {
    }

    @Override
    public boolean isPresetContentType() {
        return this.contentType == ContentType.CONTENTTYPE_PRESET;
    }

    @Override
    public int getSelectedContentTypeIndex() {
        return this.contentType.ordinal();
    }

    @Override
    public boolean hasPreviousContentType() {
        return false;
    }

    @Override
    public boolean hasNextContentType() {
        return false;
    }

    @Override
    public void previousContentType() {
    }

    @Override
    public void nextContentType() {
    }

    @Override
    public String getSelectedContentType() {
        return CONTENT_TYPE_NAMES[this.contentType.ordinal()];
    }

    @Override
    public String[] getContentTypeNames() {
        return new String[]{this.getSelectedContentType()};
    }

    private void setContentType(int ordinal) {
        ContentType[] values = ContentType.values();
        this.contentType = values[Math.min(Math.max(0, ordinal), values.length - 1)];
        this.columnData = this.columnDataContentTypes[ordinal];
        this.selectedIndex = 0;
    }

    @Override
    public void browseForPresets() {
        this.stopBrowsing(false);
        this.sender.sendOSC("/browser/preset", null);
        this.insertPosition = this.cursorDevice.getPositionInChain();
        this.setContentType(ContentType.CONTENTTYPE_PRESET.ordinal());
        this.isBrowserActive = true;
    }

    @Override
    public void browseToInsertBeforeDevice() {
        this.insertDevice(this.cursorDevice.getPositionInChain());
    }

    @Override
    public void browseToInsertAfterDevice() {
        this.insertDevice(this.cursorDevice.getPositionInChain() + 1);
    }

    private void insertDevice(int insertPos) {
        this.stopBrowsing(false);
        this.insertPosition = insertPos;
        this.setContentType(ContentType.CONTENTTYPE_DEVICE.ordinal());
        this.isBrowserActive = true;
    }

    @Override
    public void stopBrowsing(boolean commitSelection) {
        if (commitSelection && this.insertPosition >= 0) {
            switch (this.contentType) {
                case CONTENTTYPE_DEVICE: {
                    Device device;
                    ResultItem result = this.getSelectedResultDevice();
                    if (result == null || (device = result.getDevice()) == null) break;
                    this.sender.sendOSC("/device/add/" + this.insertPosition + "/", device.getCreationName());
                    break;
                }
                case CONTENTTYPE_PRESET: {
                    int index = this.getSelectedResultIndex();
                    if (index == -1) break;
                    this.sender.sendOSC("/device/preset/", index);
                }
            }
        }
        this.insertPosition = -1;
        this.isBrowserActive = false;
    }

    @Override
    public boolean isActive() {
        return this.isBrowserActive;
    }

    @Override
    public void selectPreviousResult() {
        this.setSelectedResult(this.selectedIndex - 1);
    }

    @Override
    public void selectNextResult() {
        this.setSelectedResult(this.selectedIndex + 1);
    }

    @Override
    public String getSelectedResult() {
        ResultItem result = this.getSelectedResultDevice();
        return result == null ? null : result.getName();
    }

    private ResultItem getSelectedResultDevice() {
        for (IBrowserColumnItem element : this.resultData) {
            if (!element.isSelected()) continue;
            return (ResultItem)element;
        }
        return null;
    }

    private void setSelectedResult(int index) {
        int length = this.isPresetContentType() ? this.presetCount : this.filteredDevices.size();
        this.selectedIndex = Math.min(Math.max(0, index), length - 1);
    }

    public void previousResultPage() {
        this.setSelectedResult(this.selectedIndex - this.numResults);
    }

    public void nextResultPage() {
        this.setSelectedResult(this.selectedIndex + this.numResults);
    }

    private IBrowserColumnItem[] createResultData(int count) {
        IBrowserColumnItem[] items = new IBrowserColumnItem[count];
        for (int i = 0; i < count; ++i) {
            items[i] = new ResultItem(i);
        }
        return items;
    }

    private void updateFilteredDevices() {
        DeviceManager deviceManager = DeviceManager.get();
        DeviceCollection folder = this.deviceCollectionFilterColumn.getCursorIndex() == 0 ? null : deviceManager.getCollection(this.deviceCollectionFilterColumn.getCursorName());
        String category = this.deviceCategoryFilterColumn.getCursorIndex() == 0 ? null : this.deviceCategoryFilterColumn.getCursorName();
        DeviceFileType fileType = this.deviceFileTypeFilterColumn.getCursorIndex() == 0 ? null : DeviceFileType.valueOf(this.deviceFileTypeFilterColumn.getCursorName().toUpperCase());
        DeviceLocation location = this.deviceLocationFilterColumn.getCursorIndex() == 0 ? null : DeviceLocation.valueOf(this.deviceLocationFilterColumn.getCursorName().toUpperCase());
        String vendor = this.deviceCreatorFilterColumn.getCursorIndex() == 0 ? null : this.deviceCreatorFilterColumn.getCursorName();
        DeviceType type = this.deviceTypeFilterColumn.getCursorIndex() == 0 ? null : DeviceType.valueOf(this.deviceTypeFilterColumn.getCursorName().toUpperCase().replace(' ', '_'));
        this.filteredDevices = deviceManager.filterBy(fileType, category, vendor, folder, location, type);
        if (this.selectedIndex >= this.filteredDevices.size()) {
            this.selectedIndex = 0;
        }
    }

    @Override
    public IBrowserColumnItem[] getResultColumnItems() {
        if (!this.isPresetContentType()) {
            this.updateFilteredDevices();
        }
        return super.getResultColumnItems();
    }

    public void setPreset(int index, String name) {
        this.presets[index] = name;
        for (int i = 0; i < this.presets.length; ++i) {
            if (this.presets[i] != null) continue;
            this.presetCount = i;
            break;
        }
        if (this.selectedIndex >= this.presetCount) {
            this.selectedIndex = this.presetCount - 1;
        }
    }

    public void setPresetSelected(int index) {
        this.selectedIndex = index;
    }

    int translateBankIndexToPageOfSelectedIndex(int index) {
        return this.selectedIndex / this.numResults * this.numResults + index;
    }

    private class ResultItem
    implements IBrowserColumnItem {
        private final int index;

        public ResultItem(int index) {
            this.index = index;
        }

        @Override
        public void enableObservers(boolean enable) {
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean doesExist() {
            if (BrowserImpl.this.isPresetContentType()) {
                return BrowserImpl.this.presets[this.index] != null;
            }
            return this.index < BrowserImpl.this.filteredDevices.size();
        }

        @Override
        public String getName() {
            if (BrowserImpl.this.isPresetContentType()) {
                return BrowserImpl.this.presets[this.index] == null ? "" : BrowserImpl.this.presets[this.index];
            }
            int id = BrowserImpl.this.translateBankIndexToPageOfSelectedIndex(this.index);
            return id < BrowserImpl.this.filteredDevices.size() ? BrowserImpl.this.filteredDevices.get(id).getDisplayName() : "";
        }

        @Override
        public String getName(int limit) {
            return StringUtils.optimizeName(this.getName(), limit);
        }

        @Override
        public boolean isSelected() {
            return BrowserImpl.this.translateBankIndexToPageOfSelectedIndex(this.index) == BrowserImpl.this.selectedIndex;
        }

        @Override
        public int getHitCount() {
            return 0;
        }

        public Device getDevice() {
            int id = BrowserImpl.this.translateBankIndexToPageOfSelectedIndex(this.index);
            return id < BrowserImpl.this.filteredDevices.size() ? BrowserImpl.this.filteredDevices.get(id) : null;
        }
    }

    private static enum ContentType {
        CONTENTTYPE_DEVICE,
        CONTENTTYPE_PRESET;

    }
}

