/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public class ApplicationImpl
extends BaseImpl
implements IApplication {
    private String panelLayout = "ARRANGE";
    private boolean engineActive = true;

    public ApplicationImpl(MessageSender sender, IHost host) {
        super(sender, host);
    }

    @Override
    public boolean isEngineActive() {
        return this.engineActive;
    }

    @Override
    public void setEngineActive(boolean active) {
        this.sender.sendOSC("/project/engine", active ? 1 : 0);
    }

    @Override
    public void toggleEngineActive() {
        this.setEngineActive(!this.engineActive);
    }

    @Override
    public void setPanelLayout(String panelLayout) {
        this.panelLayout = panelLayout;
        switch (panelLayout) {
            case "ARRANGE": {
                this.sender.invokeAction(40454);
                break;
            }
            case "MIX": {
                this.sender.invokeAction(40455);
                break;
            }
            case "EDIT": {
                this.sender.invokeAction(40456);
                break;
            }
            default: {
                this.host.println("Not a supported layout: " + panelLayout);
            }
        }
    }

    @Override
    public String getPanelLayout() {
        return this.panelLayout;
    }

    @Override
    public boolean isArrangeLayout() {
        return false;
    }

    @Override
    public boolean isMixerLayout() {
        return true;
    }

    @Override
    public boolean isEditLayout() {
        return false;
    }

    @Override
    public boolean isPlayLayout() {
        return false;
    }

    @Override
    public void toggleNoteEditor() {
        this.sender.invokeAction(40716);
    }

    @Override
    public void toggleAutomationEditor() {
        this.sender.invokeAction(40926);
    }

    @Override
    public void toggleDevices() {
        this.sender.invokeAction("_S&M_TOGLFXCHAIN");
    }

    @Override
    public void toggleInspector() {
        this.sender.invokeAction(40906);
    }

    @Override
    public void toggleMixer() {
        this.sender.invokeAction(40078);
    }

    @Override
    public void toggleFullScreen() {
        this.sender.invokeAction(40346);
    }

    @Override
    public void toggleBrowserVisibility() {
        this.sender.invokeAction(50124);
    }

    @Override
    public void duplicate() {
    }

    @Override
    public void deleteSelection() {
        this.sender.invokeAction(40006);
    }

    @Override
    public void redo() {
        this.sender.sendOSC("/redo", null);
    }

    @Override
    public void undo() {
        this.sender.sendOSC("/undo", null);
    }

    @Override
    public void addAudioTrack() {
        this.sender.invokeAction(40001);
    }

    @Override
    public void addEffectTrack() {
        this.sender.invokeAction(41147);
    }

    @Override
    public void addInstrumentTrack() {
        this.sender.invokeAction(46000);
    }

    @Override
    public void arrowKeyLeft() {
        this.sender.invokeAction(40286);
    }

    @Override
    public void arrowKeyUp() {
        this.sender.invokeAction(40286);
    }

    @Override
    public void arrowKeyRight() {
        this.sender.invokeAction(40285);
    }

    @Override
    public void arrowKeyDown() {
        this.sender.invokeAction(40285);
    }

    @Override
    public void zoomOut() {
        this.sender.invokeAction(1011);
    }

    @Override
    public void zoomIn() {
        this.sender.invokeAction(1012);
    }

    @Override
    public void decTrackHeight() {
        this.sender.invokeAction(40112);
    }

    @Override
    public void incTrackHeight() {
        this.sender.invokeAction(40111);
    }

    @Override
    public void enter() {
    }

    @Override
    public void escape() {
    }

    public void setInternalEngineActive(boolean active) {
        this.engineActive = active;
    }
}

