/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.AbstractChannelBank;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.transformator.communication.MessageSender;

public abstract class AbstractTrackBankImpl
extends AbstractChannelBank {
    private MessageSender sender;
    private IHost host;
    private int trackCount = 1000;

    public AbstractTrackBankImpl(IHost host, MessageSender sender, IValueChanger valueChanger, int numTracks, int numScenes, int numSends) {
        super(valueChanger, numTracks, numScenes, numSends);
        this.sender = sender;
        this.host = host;
    }

    public void init() {
        this.tracks = this.createTracks(this.numTracks);
    }

    @Override
    public void enableObservers(boolean enable) {
    }

    @Override
    public int getTrackCount() {
        return this.trackCount;
    }

    @Override
    public boolean canScrollTracksUp() {
        return this.tracks[0].getPosition() > 0;
    }

    @Override
    public boolean canScrollTracksDown() {
        ITrack sel = this.getSelectedTrack();
        return sel != null && sel.getPosition() < this.getTrackCount() - 1;
    }

    @Override
    public void scrollTracksUp() {
    }

    @Override
    public void scrollTracksDown() {
    }

    @Override
    public void scrollTracksPageUp() {
        ITrack selectedTrack = this.getSelectedTrack();
        if (selectedTrack != null) {
            this.sendTrackOSC(selectedTrack.getIndex() + 1 + "/select", 0);
        }
        this.sendTrackOSC("bank/-", null);
        this.sendTrackOSC(this.getNumTracks() + "/select", 1);
    }

    @Override
    public void scrollTracksPageDown() {
        ITrack selectedTrack = this.getSelectedTrack();
        if (selectedTrack != null) {
            this.sendTrackOSC(selectedTrack.getIndex() + 1 + "/select", 0);
        }
        this.sendTrackOSC("bank/+", null);
        this.sendTrackOSC("1/select", 1);
    }

    @Override
    public void scrollToChannel(int channel) {
    }

    @Override
    public void scrollToScene(int position) {
    }

    @Override
    public void setIndication(boolean enable) {
    }

    @Override
    public int getTrackPositionFirst() {
        return this.getTrack(0).getPosition();
    }

    @Override
    public int getTrackPositionLast() {
        for (int i = 7; i >= 0; --i) {
            int pos = this.getTrack(i).getPosition();
            if (pos < 0) continue;
            return pos;
        }
        return -1;
    }

    protected ITrack[] createTracks(int count) {
        ITrack[] trackData = new TrackImpl[count];
        for (int i = 0; i < count; ++i) {
            trackData[i] = new TrackImpl(this.host, this.sender, this.valueChanger, i, this.numSends, this.numScenes);
        }
        return trackData;
    }

    public void setTrackCount(int trackCount) {
        this.trackCount = trackCount;
    }

    protected void sendTrackOSC(String command, Object value) {
        this.sender.sendOSC("/track/" + command + "/", value);
    }

    public void handleBankTrackSelection(int index, boolean isSelected) {
        if (index < 0) {
            return;
        }
        this.getTrack(index).setSelected(isSelected);
        this.notifyTrackSelectionObservers(index, isSelected);
    }
}

