/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IStringSetting;
import de.mossgrabers.reaper.framework.configuration.BaseSetting;
import de.mossgrabers.transformator.util.PropertiesEx;
import javafx.application.Platform;
import javafx.scene.control.TextField;

public class StringSettingImpl
extends BaseSetting<TextField, String>
implements IStringSetting {
    private String value;

    public StringSettingImpl(String label, String category, String initialValue) {
        super(label, category, new TextField(initialValue));
        this.value = initialValue;
        ((TextField)this.field).textProperty().addListener((observable, oldValue, newValue) -> this.set((String)newValue));
    }

    @Override
    public void set(String value) {
        this.value = value;
        this.flush();
        Platform.runLater(() -> {
            String v = (String)((TextField)this.field).textProperty().get();
            if (v == null || !v.equals(this.value)) {
                ((TextField)this.field).textProperty().set((Object)this.value);
            }
        });
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), this.value);
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getString(this.getID(), this.value));
    }
}

