/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IBooleanSetting;
import de.mossgrabers.framework.configuration.IColorSetting;
import de.mossgrabers.framework.configuration.IDoubleSetting;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.ISignalSetting;
import de.mossgrabers.framework.configuration.IStringSetting;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.reaper.framework.configuration.BooleanSettingImpl;
import de.mossgrabers.reaper.framework.configuration.ColorSettingImpl;
import de.mossgrabers.reaper.framework.configuration.DoubleSettingImpl;
import de.mossgrabers.reaper.framework.configuration.EnumSettingImpl;
import de.mossgrabers.reaper.framework.configuration.IfxSetting;
import de.mossgrabers.reaper.framework.configuration.IntegerSettingImpl;
import de.mossgrabers.reaper.framework.configuration.SignalSettingImpl;
import de.mossgrabers.reaper.framework.configuration.StringSettingImpl;
import de.mossgrabers.transformator.midi.Midi;
import de.mossgrabers.transformator.midi.MidiDeviceConverter;
import de.mossgrabers.transformator.util.PropertiesEx;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;
import javax.sound.midi.MidiDevice;

public class SettingsUI
implements ISettingsUI {
    private static final String TAG_MIDI_INPUT = "MIDI_INPUT";
    private static final String TAG_MIDI_OUTPUT = "MIDI_OUTPUT";
    private final List<IfxSetting<?>> settings = new ArrayList();
    private final int numMidiInPorts;
    private final int numMidiOutPorts;
    private final List<Pair<String[], String[]>> discoveryPairs;
    private final List<ComboBox<MidiDevice>> midiInputs = new ArrayList<ComboBox<MidiDevice>>();
    private final List<ComboBox<MidiDevice>> midiOutputs = new ArrayList<ComboBox<MidiDevice>>();
    private final MidiDevice[] selectedMidiInputs;
    private final MidiDevice[] selectedMidiOutputs;

    public SettingsUI(int numMidiInPorts, int numMidiOutPorts, List<Pair<String[], String[]>> discoveryPairs) {
        this.numMidiInPorts = numMidiInPorts;
        this.numMidiOutPorts = numMidiOutPorts;
        this.discoveryPairs = discoveryPairs;
        this.selectedMidiInputs = new MidiDevice[this.numMidiInPorts];
        this.selectedMidiOutputs = new MidiDevice[this.numMidiOutPorts];
    }

    public MidiDevice getSelectedMidiInput(int index) {
        return this.selectedMidiInputs[index];
    }

    public MidiDevice getSelectedMidiOutput(int index) {
        return this.selectedMidiOutputs[index];
    }

    public MidiDevice[] getSelectedMidiInputs() {
        return this.selectedMidiInputs;
    }

    public MidiDevice[] getSelectedMidiOutputs() {
        return this.selectedMidiOutputs;
    }

    public List<ComboBox<MidiDevice>> createMidiInputWidgets() {
        this.midiInputs.clear();
        int i = 0;
        while (i < this.numMidiInPorts) {
            ComboBox midiInput = new ComboBox();
            midiInput.setConverter((StringConverter)new MidiDeviceConverter());
            midiInput.setMaxWidth(Double.MAX_VALUE);
            this.midiInputs.add((ComboBox<MidiDevice>)midiInput);
            int index = i++;
            midiInput.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                this.selectedMidiInputs[index] = newValue;
            });
        }
        return this.midiInputs;
    }

    public List<ComboBox<MidiDevice>> createMidiOutputWidgets() {
        this.midiOutputs.clear();
        int i = 0;
        while (i < this.numMidiOutPorts) {
            ComboBox midiOutput = new ComboBox();
            midiOutput.setConverter((StringConverter)new MidiDeviceConverter());
            midiOutput.setMaxWidth(Double.MAX_VALUE);
            this.midiOutputs.add((ComboBox<MidiDevice>)midiOutput);
            int index = i++;
            midiOutput.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                this.selectedMidiOutputs[index] = newValue;
            });
        }
        return this.midiOutputs;
    }

    public void flush() {
        this.settings.forEach(s -> s.flush());
    }

    public void load(PropertiesEx properties) {
        int i;
        block0: for (i = 0; i < this.numMidiInPorts; ++i) {
            this.selectedMidiInputs[i] = Midi.getInputDevice(properties.getString(TAG_MIDI_INPUT + i));
            if (this.selectedMidiInputs[i] != null) continue;
            for (Pair<String[], String[]> pair : this.discoveryPairs) {
                this.selectedMidiInputs[i] = Midi.getInputDevice(pair.getKey()[i]);
                if (this.selectedMidiInputs[i] == null) continue;
                continue block0;
            }
        }
        block2: for (i = 0; i < this.numMidiOutPorts; ++i) {
            this.selectedMidiOutputs[i] = Midi.getOutputDevice(properties.getString(TAG_MIDI_OUTPUT + i));
            if (this.selectedMidiOutputs[i] != null) continue;
            for (Pair<String[], String[]> pair : this.discoveryPairs) {
                this.selectedMidiOutputs[i] = Midi.getOutputDevice(pair.getKey()[i]);
                if (this.selectedMidiOutputs[i] == null) continue;
                continue block2;
            }
        }
        this.settings.forEach(s -> s.load(properties));
    }

    public void store(PropertiesEx properties) {
        MidiDevice midiDevice;
        int i;
        for (i = 0; i < this.numMidiInPorts; ++i) {
            midiDevice = this.getSelectedMidiInput(i);
            if (midiDevice == null) {
                properties.remove(TAG_MIDI_INPUT + i);
                continue;
            }
            properties.putString(TAG_MIDI_INPUT + i, midiDevice.getDeviceInfo().getName());
        }
        for (i = 0; i < this.numMidiOutPorts; ++i) {
            midiDevice = this.getSelectedMidiOutput(i);
            if (midiDevice == null) {
                properties.remove(TAG_MIDI_OUTPUT + i);
                continue;
            }
            properties.putString(TAG_MIDI_OUTPUT + i, midiDevice.getDeviceInfo().getName());
        }
        this.settings.forEach(s -> s.store(properties));
    }

    public List<IfxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public IEnumSetting getEnumSetting(String label, String category, String[] options, String initialValue) {
        EnumSettingImpl setting = new EnumSettingImpl(label, category, options, initialValue);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IStringSetting getStringSetting(String label, String category, int numChars, String initialText) {
        StringSettingImpl setting = new StringSettingImpl(label, category, initialText);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IDoubleSetting getNumberSetting(String label, String category, double minValue, double maxValue, double stepResolution, String unit, double initialValue) {
        DoubleSettingImpl setting = new DoubleSettingImpl(label, category, initialValue);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IIntegerSetting getRangeSetting(String label, String category, int minValue, int maxValue, int stepResolution, String unit, int initialValue) {
        IntegerSettingImpl setting = new IntegerSettingImpl(label, category, initialValue, minValue, maxValue);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public ISignalSetting getSignalSetting(String label, String category, String title) {
        SignalSettingImpl setting = new SignalSettingImpl(label, category, title);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IColorSetting getColorSetting(String label, String category, ColorEx defaultColor) {
        ColorSettingImpl setting = new ColorSettingImpl(label, category, defaultColor);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IBooleanSetting getBooleanSetting(String label, String category, boolean initialValue) {
        BooleanSettingImpl setting = new BooleanSettingImpl(label, category, initialValue);
        this.settings.add(setting);
        return setting;
    }
}

