/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.reaper.framework.configuration.BaseSetting;
import de.mossgrabers.transformator.util.PropertiesEx;
import javafx.application.Platform;
import javafx.scene.control.TextField;

public class IntegerSettingImpl
extends BaseSetting<TextField, Integer>
implements IIntegerSetting {
    private final int minValue;
    private final int maxValue;
    private int value;

    public IntegerSettingImpl(String label, String category, int initialValue, int minValue, int maxValue) {
        super(label, category, new TextField(Integer.toString(initialValue)));
        this.value = initialValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        IntegerSettingImpl.limitToNumbers((TextField)this.field, "0123456789");
        ((TextField)this.field).textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                this.set(Integer.parseInt(newValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    @Override
    public void set(Integer value) {
        this.set((int)value);
    }

    @Override
    public void set(int value) {
        if (value < this.minValue || value > this.maxValue) {
            return;
        }
        this.value = value;
        this.flush();
        Platform.runLater(() -> {
            String v = (String)((TextField)this.field).textProperty().get();
            if (!v.equals(Integer.toString(this.value))) {
                ((TextField)this.field).textProperty().set((Object)Integer.toString(this.value));
            }
        });
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value - 1);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), Integer.toString(this.value));
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getInt(this.getID(), this.value));
    }
}

