/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.reaper.framework.configuration.BaseSetting;
import de.mossgrabers.transformator.util.PropertiesEx;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.FXCollections;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SingleSelectionModel;

public class EnumSettingImpl
extends BaseSetting<ComboBox<String>, String>
implements IEnumSetting {
    private String value;

    public EnumSettingImpl(String label, String category, String[] options, String initialValue) {
        super(label, category, new ComboBox(FXCollections.observableArrayList((Object[])options)));
        this.value = initialValue;
        SingleSelectionModel selectionModel = ((ComboBox)this.field).getSelectionModel();
        selectionModel.select((Object)this.value);
        selectionModel.selectedItemProperty().addListener((observable, oldValue, newValue) -> this.set((String)newValue));
        ((ComboBox)this.field).setMaxWidth(Double.MAX_VALUE);
    }

    @Override
    public void set(String value) {
        this.value = value;
        this.flush();
        Platform.runLater(() -> {
            SingleSelectionModel selectionModel = ((ComboBox)this.field).getSelectionModel();
            ReadOnlyObjectProperty selectedItemProperty = selectionModel.selectedItemProperty();
            if (this.value != null && !this.value.equals(selectedItemProperty.get())) {
                selectionModel.select((Object)this.value);
            }
        });
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), this.value);
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getString(this.getID(), this.value));
    }

    @Override
    public void setEnabled(boolean enable) {
        ((ComboBox)this.field).disableProperty().set(!enable);
    }
}

