/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IDoubleSetting;
import de.mossgrabers.reaper.framework.configuration.BaseSetting;
import de.mossgrabers.transformator.util.PropertiesEx;
import javafx.application.Platform;
import javafx.scene.control.TextField;

public class DoubleSettingImpl
extends BaseSetting<TextField, Double>
implements IDoubleSetting {
    private double value;

    public DoubleSettingImpl(String label, String category, double initialValue) {
        super(label, category, new TextField(Double.toString(initialValue)));
        this.value = initialValue;
        DoubleSettingImpl.limitToNumbers((TextField)this.field, ".0123456789");
        ((TextField)this.field).textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                this.set(Double.parseDouble(newValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    @Override
    public void set(Double value) {
        this.set((double)value);
    }

    @Override
    public void set(double value) {
        this.value = value;
        this.flush();
        Platform.runLater(() -> {
            String v = (String)((TextField)this.field).textProperty().get();
            if (!v.equals(Double.toString(this.value))) {
                ((TextField)this.field).textProperty().set((Object)Double.toString(this.value));
            }
        });
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), Double.toString(this.value));
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getDouble(this.getID(), this.value));
    }
}

