/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IColorSetting;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.reaper.framework.configuration.BaseSetting;
import de.mossgrabers.transformator.util.PropertiesEx;
import javafx.application.Platform;
import javafx.scene.control.ColorPicker;
import javafx.scene.paint.Color;

public class ColorSettingImpl
extends BaseSetting<ColorPicker, double[]>
implements IColorSetting {
    private ColorEx value;

    public ColorSettingImpl(String label, String category, ColorEx initialValue) {
        super(label, category, new ColorPicker(Color.color((double)initialValue.getRed(), (double)initialValue.getGreen(), (double)initialValue.getBlue())));
        this.value = initialValue;
        ((ColorPicker)this.field).setMaxWidth(Double.MAX_VALUE);
        ((ColorPicker)this.field).setMinHeight(30.0);
        ((ColorPicker)this.field).setOnAction(event -> {
            Color color = (Color)((ColorPicker)this.field).getValue();
            this.set(color.getRed(), color.getGreen(), color.getBlue());
        });
    }

    @Override
    public void set(double[] value) {
        this.set(value[0], value[1], value[2]);
    }

    @Override
    public void set(double red, double green, double blue) {
        this.set(new ColorEx(red, green, blue));
    }

    @Override
    public void set(ColorEx value) {
        this.value = value;
        this.flush();
        Platform.runLater(() -> {
            Color c = (Color)((ColorPicker)this.field).getValue();
            if (this.value.getRed() != c.getRed() || this.value.getGreen() != c.getGreen() || this.value.getBlue() != c.getBlue()) {
                ((ColorPicker)this.field).setValue((Object)Color.color((double)this.value.getRed(), (double)this.value.getGreen(), (double)this.value.getBlue()));
            }
        });
    }

    @Override
    public void flush() {
        this.notifyObservers(new double[]{this.value.getRed(), this.value.getGreen(), this.value.getBlue()});
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), this.value.getRed() + "," + this.value.getGreen() + "," + this.value.getBlue());
    }

    @Override
    public void load(PropertiesEx properties) {
        String color = properties.getString(this.getID());
        if (color == null) {
            return;
        }
        String[] parts = color.split(",");
        if (parts.length == 3) {
            this.set(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]));
        }
    }
}

