/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IBooleanSetting;
import de.mossgrabers.reaper.framework.configuration.BaseSetting;
import de.mossgrabers.transformator.util.PropertiesEx;
import javafx.application.Platform;
import javafx.scene.control.CheckBox;

public class BooleanSettingImpl
extends BaseSetting<CheckBox, Boolean>
implements IBooleanSetting {
    private boolean value;

    public BooleanSettingImpl(String label, String category, boolean initialValue) {
        super(label, category, new CheckBox());
        this.value = initialValue;
        ((CheckBox)this.field).selectedProperty().addListener((observable, oldValue, newValue) -> this.set((Boolean)newValue));
    }

    @Override
    public void set(Boolean value) {
        this.set((boolean)value);
    }

    @Override
    public void set(boolean value) {
        this.value = value;
        this.flush();
        Platform.runLater(() -> {
            boolean v = ((CheckBox)this.field).selectedProperty().get();
            if (v != this.value) {
                ((CheckBox)this.field).selectedProperty().set(this.value);
            }
        });
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), Boolean.toString(this.value));
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getBoolean(this.getID(), this.value));
    }
}

