/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IValueObserver;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.framework.configuration.IfxSetting;
import java.util.HashSet;
import java.util.Set;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;

public abstract class BaseSetting<C extends Control, T>
implements IfxSetting<T> {
    protected static final String NUMBERS = "0123456789";
    protected static final String SIGNED_NUMBERS = "-0123456789";
    protected static final String NUMBERS_AND_DOT = ".0123456789";
    protected static final String SIGNED_NUMBERS_AND_DOT = ".-0123456789";
    protected final C field;
    private final Label labelWidget;
    private final Set<IValueObserver<T>> observers = new HashSet<IValueObserver<T>>();
    private final String label;
    private final String category;

    public BaseSetting(String label, String category, C field) {
        this.label = label;
        this.category = category;
        this.field = field;
        this.labelWidget = new Label(this.label);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getID() {
        return StringUtils.fixASCII((this.category + '_' + this.label).toUpperCase()).replace(' ', '_').replace('?', '_');
    }

    @Override
    public Label getLabelWidget() {
        return this.labelWidget;
    }

    @Override
    public Control getWidget() {
        return this.field;
    }

    @Override
    public void addValueObserver(IValueObserver<T> observer) {
        this.observers.add(observer);
    }

    protected void notifyObservers(T value) {
        for (IValueObserver<T> observer : this.observers) {
            observer.update(value);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.labelWidget.disableProperty().set(!enable);
        this.field.disableProperty().set(!enable);
    }

    @Override
    public void setVisible(boolean visible) {
        this.labelWidget.setVisible(visible);
        this.labelWidget.setManaged(visible);
        this.field.setVisible(visible);
        this.field.setManaged(visible);
    }

    protected static void limitToNumbers(TextField field, String characters) {
        field.addEventFilter(KeyEvent.KEY_TYPED, keyEvent -> {
            if (!characters.contains(keyEvent.getCharacter())) {
                keyEvent.consume();
            }
        });
    }
}

