/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework;

import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.reaper.framework.daw.ModelImpl;
import de.mossgrabers.reaper.framework.midi.MidiAccessImpl;
import de.mossgrabers.transformator.communication.MessageSender;
import de.mossgrabers.transformator.util.LogModel;
import javax.sound.midi.MidiDevice;

public class ReaperSetupFactory
implements ISetupFactory {
    private final MessageSender sender;
    private final IHost host;
    private final MidiAccessImpl midiAccess;

    public ReaperSetupFactory(MessageSender sender, IHost host, LogModel logModel, MidiDevice[] inputs, MidiDevice[] outputs) {
        this.sender = sender;
        this.host = host;
        this.midiAccess = new MidiAccessImpl(logModel, this.host, this.sender, inputs, outputs);
    }

    public void cleanup() {
        this.midiAccess.cleanup();
    }

    @Override
    public IModel createModel(ColorManager colorManager, IValueChanger valueChanger, Scales scales, int numTracks, int numScenes, int numSends, int numFilterColumnEntries, int numResults, boolean hasFlatTrackList, int numParams, int numDevicesInBank, int numDeviceLayers, int numDrumPadLayers) {
        return new ModelImpl(this.sender, this.host, colorManager, valueChanger, scales, numTracks, numScenes, numSends, numFilterColumnEntries, numResults, hasFlatTrackList, numParams, numDevicesInBank, numDeviceLayers, numDrumPadLayers);
    }

    @Override
    public IMidiAccess createMidiAccess() {
        return this.midiAccess;
    }
}

