/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.controller;

import de.mossgrabers.controller.apc.APCControllerDefinition;
import de.mossgrabers.controller.apcmini.APCminiControllerDefinition;
import de.mossgrabers.controller.beatstep.BeatstepControllerDefinition;
import de.mossgrabers.controller.generic.GenericFlexiControllerDefinition;
import de.mossgrabers.controller.launchpad.LaunchpadControllerDefinition;
import de.mossgrabers.controller.mcu.MCUControllerDefinition;
import de.mossgrabers.controller.osc.OSCControllerDefinition;
import de.mossgrabers.controller.push.PushControllerDefinition;
import de.mossgrabers.controller.sl.SLControllerDefinition;
import de.mossgrabers.framework.controller.IControllerDefinition;
import de.mossgrabers.reaper.controller.IControllerInstance;
import de.mossgrabers.reaper.controller.apc.APC40mkIControllerInstance;
import de.mossgrabers.reaper.controller.apc.APC40mkIIControllerInstance;
import de.mossgrabers.reaper.controller.apcmini.APCminiControllerInstance;
import de.mossgrabers.reaper.controller.beatstep.BeatstepControllerInstance;
import de.mossgrabers.reaper.controller.beatstep.BeatstepProControllerInstance;
import de.mossgrabers.reaper.controller.generic.GenericFlexiControllerInstance;
import de.mossgrabers.reaper.controller.launchpad.LaunchpadMkIIControllerInstance;
import de.mossgrabers.reaper.controller.launchpad.LaunchpadProControllerInstance;
import de.mossgrabers.reaper.controller.mcu.MCU1ControllerInstance;
import de.mossgrabers.reaper.controller.osc.OSCControllerInstance;
import de.mossgrabers.reaper.controller.push.Push1ControllerInstance;
import de.mossgrabers.reaper.controller.push.Push2ControllerInstance;
import de.mossgrabers.reaper.controller.sl.SLMkIControllerInstance;
import de.mossgrabers.reaper.controller.sl.SLMkIIControllerInstance;
import de.mossgrabers.transformator.communication.MessageSender;
import de.mossgrabers.transformator.util.LogModel;
import de.mossgrabers.transformator.util.PropertiesEx;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javafx.stage.Window;

public class ControllerInstanceManager {
    private static final String CONTROLLER_INSTANCE_TAG = "CONTROLLER_INSTANCE";
    private static final Class<?>[] CLASSES = new Class[]{Push1ControllerInstance.class, Push2ControllerInstance.class, APC40mkIControllerInstance.class, APC40mkIIControllerInstance.class, APCminiControllerInstance.class, BeatstepControllerInstance.class, BeatstepProControllerInstance.class, GenericFlexiControllerInstance.class, LaunchpadMkIIControllerInstance.class, LaunchpadProControllerInstance.class, MCU1ControllerInstance.class, OSCControllerInstance.class, SLMkIControllerInstance.class, SLMkIIControllerInstance.class};
    private static final IControllerDefinition[] DEFINITIONS = new IControllerDefinition[]{new PushControllerDefinition(false), new PushControllerDefinition(true), new APCControllerDefinition(false), new APCControllerDefinition(true), new APCminiControllerDefinition(), new BeatstepControllerDefinition(false), new BeatstepControllerDefinition(true), new GenericFlexiControllerDefinition(), new LaunchpadControllerDefinition(true), new LaunchpadControllerDefinition(false), new MCUControllerDefinition(0), new OSCControllerDefinition(), new SLControllerDefinition(false), new SLControllerDefinition(true)};
    private static final Class<?>[] CONSTRUCTOR_TYPES = new Class[]{LogModel.class, Window.class, MessageSender.class};
    private final List<IControllerInstance> instances = new ArrayList<IControllerInstance>();
    private final LogModel logModel;
    private final Window window;
    private final MessageSender sender;

    public ControllerInstanceManager(LogModel logModel, Window window, MessageSender sender) {
        this.logModel = logModel;
        this.window = window;
        this.sender = sender;
    }

    public IControllerDefinition[] getDefinitions() {
        return DEFINITIONS;
    }

    public void startAll() {
        this.instances.forEach(IControllerInstance::start);
    }

    public void stopAll() {
        this.instances.forEach(IControllerInstance::stop);
    }

    public boolean areRunning() {
        for (IControllerInstance inst : this.instances) {
            if (inst.isRunning()) continue;
            return false;
        }
        return true;
    }

    public void flushAll() {
        this.instances.forEach(IControllerInstance::flush);
    }

    public void parseAll(String address, String argument) {
        this.instances.forEach(inst -> inst.parse(address, argument));
    }

    public void edit(int index) {
        this.instances.get(index).edit();
    }

    public void remove(int index) {
        IControllerInstance controllerInstance = this.instances.remove(index);
        if (controllerInstance != null) {
            controllerInstance.stop();
        }
    }

    public IControllerInstance instantiate(int definitionIndex) {
        return this.instantiateController(CLASSES[definitionIndex]);
    }

    public boolean isInstantiated(int definitionIndex) {
        for (IControllerInstance inst : this.instances) {
            if (!inst.getClass().equals(CLASSES[definitionIndex])) continue;
            return true;
        }
        return false;
    }

    public List<IControllerInstance> getInstances() {
        return new ArrayList<IControllerInstance>(this.instances);
    }

    public void load(PropertiesEx properties) {
        String className;
        int counter = 0;
        while ((className = properties.getString(CONTROLLER_INSTANCE_TAG + counter)) != null) {
            Class<?> clazz = ControllerInstanceManager.lookupClass(className);
            if (clazz == null) {
                this.logModel.addLogMessage("Unknown controller  class: " + className);
            } else {
                this.instantiateController(clazz);
            }
            ++counter;
        }
    }

    public void save(PropertiesEx properties) {
        for (int i = 0; i < this.instances.size(); ++i) {
            IControllerInstance inst = this.instances.get(i);
            properties.putString(CONTROLLER_INSTANCE_TAG + i, inst.getClass().getName());
        }
        properties.remove(CONTROLLER_INSTANCE_TAG + this.instances.size());
    }

    private IControllerInstance instantiateController(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getConstructor(CONSTRUCTOR_TYPES);
            IControllerInstance newInstance = (IControllerInstance)constructor.newInstance(this.logModel, this.window, this.sender);
            this.instances.add(newInstance);
            return newInstance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            this.logModel.addLogMessage("Could not instantiate controller  class: " + clazz.getName() + ". " + ex.getMessage());
            return null;
        }
    }

    private static Class<?> lookupClass(String className) {
        for (Class<?> clazz : CLASSES) {
            if (!clazz.getName().equals(className)) continue;
            return clazz;
        }
        return null;
    }
}

