/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.controller;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControllerDefinition;
import de.mossgrabers.framework.controller.IControllerSetup;
import de.mossgrabers.framework.usb.USBMatcher;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.reaper.controller.IControllerInstance;
import de.mossgrabers.reaper.framework.ReaperSetupFactory;
import de.mossgrabers.reaper.framework.configuration.SettingsUI;
import de.mossgrabers.reaper.framework.daw.HostImpl;
import de.mossgrabers.transformator.ConfigurationDialog;
import de.mossgrabers.transformator.communication.MessageParser;
import de.mossgrabers.transformator.communication.MessageSender;
import de.mossgrabers.transformator.util.LogModel;
import de.mossgrabers.transformator.util.PropertiesEx;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javafx.application.Platform;
import javafx.stage.Window;

public abstract class AbstractControllerInstance
implements IControllerInstance {
    protected final LogModel logModel;
    protected final Window window;
    protected final MessageSender sender;
    protected final IControllerDefinition controllerDefinition;
    protected HostImpl host;
    protected SettingsUI settingsUI;
    protected ReaperSetupFactory setupFactory;
    protected IControllerSetup controllerSetup;
    protected PropertiesEx controllerConfiguration = new PropertiesEx();
    protected MessageParser oscParser;
    private boolean isRunning = false;
    private final Object startSync = new Object();

    public AbstractControllerInstance(IControllerDefinition controllerDefinition, LogModel logModel, Window window, MessageSender sender) {
        this.logModel = logModel;
        this.window = window;
        this.sender = sender;
        this.controllerDefinition = controllerDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.startSync;
        synchronized (object) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.startSync;
        synchronized (object) {
            USBMatcher matcher;
            if (this.isRunning) {
                return;
            }
            this.logModel.addLogMessage("Starting controller '" + this.controllerDefinition.toString() + "'");
            this.host = new HostImpl(this.logModel, this.window, this.sender);
            this.settingsUI = new SettingsUI(this.controllerDefinition.getNumMidiInPorts(), this.controllerDefinition.getNumMidiOutPorts(), this.controllerDefinition.getMidiDiscoveryPairs(OperatingSystem.get()));
            File configFile = new File(this.getFileName());
            if (configFile.exists()) {
                try (FileReader reader = new FileReader(configFile);){
                    this.controllerConfiguration.load(reader);
                }
                catch (IOException ex) {
                    this.logModel.addLogMessage("Could not load controller configuration file: " + ex.getLocalizedMessage());
                }
            }
            if ((matcher = this.controllerDefinition.claimUSBDevice()) != null) {
                this.host.addUSBDeviceInfo(matcher);
            }
            this.settingsUI.load(this.controllerConfiguration);
            this.setupFactory = new ReaperSetupFactory(this.sender, this.host, this.logModel, this.settingsUI.getSelectedMidiInputs(), this.settingsUI.getSelectedMidiOutputs());
            this.controllerSetup = this.createControllerSetup(this.setupFactory);
            Platform.runLater(() -> {
                this.controllerSetup.init();
                this.settingsUI.load(this.controllerConfiguration);
                Configuration configuration = this.controllerSetup.getConfiguration();
                configuration.addSettingObserver(AbstractConfiguration.QUANTIZE_AMOUNT, () -> this.sender.sendOSC("/quantize/strength", configuration.getQuantizeAmount()));
                this.oscParser = new MessageParser(this.controllerSetup);
                this.settingsUI.flush();
                this.host.scheduleTask(this.controllerSetup::startup, 1000L);
                this.isRunning = true;
            });
        }
    }

    protected abstract IControllerSetup createControllerSetup(ReaperSetupFactory var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.startSync;
        synchronized (object) {
            if (!this.isRunning) {
                return;
            }
            this.logModel.addLogMessage("Closing controller...");
            if (this.controllerSetup != null) {
                this.controllerSetup.exit();
            }
            if (this.host != null) {
                this.host.shutdown();
                this.logModel.addLogMessage("Release resources...");
                this.host.releaseUsbDevices();
                this.host.releaseOSC();
            }
            this.logModel.addLogMessage("Closing midi connections...");
            if (this.setupFactory != null) {
                this.setupFactory.cleanup();
            }
            this.isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.startSync;
        synchronized (object) {
            if (!this.isRunning) {
                return;
            }
            if (this.controllerSetup != null) {
                this.controllerSetup.flush();
            }
        }
    }

    @Override
    public void parse(String address, String argument) {
        if (this.oscParser != null) {
            this.oscParser.parseOSC(address, argument);
        }
    }

    @Override
    public void edit() {
        new ConfigurationDialog(this.logModel, this.window, this.settingsUI).showAndWait();
        try (FileWriter writer = new FileWriter(this.getFileName());){
            this.settingsUI.store(this.controllerConfiguration);
            this.controllerConfiguration.store(writer, "");
        }
        catch (IOException ex) {
            this.logModel.addLogMessage("Could not load controller configuration file: " + ex.getLocalizedMessage());
        }
    }

    public String toString() {
        return this.controllerDefinition.toString();
    }

    private String getFileName() {
        return "DrivenByMoss4Reaper-" + this.controllerDefinition.getHardwareModel().replace(' ', '-') + ".config";
    }
}

