/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.command.core.AftertouchCommand;
import de.mossgrabers.framework.command.core.ContinuousCommand;
import de.mossgrabers.framework.command.core.PitchbendCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewManager {
    private final Map<Integer, View> views = new HashMap<Integer, View>();
    private final List<ViewChangeListener> viewChangeListeners = new ArrayList<ViewChangeListener>();
    private final Map<Integer, Integer> preferredViews = new HashMap<Integer, Integer>();
    private Integer activeViewId = -1;
    private Integer previousViewId = -1;

    public void registerView(Integer viewId, View view) {
        this.views.put(viewId, view);
        view.onDeactivate();
    }

    public View getView(Integer viewId) {
        return this.views.get(viewId);
    }

    public void setActiveView(Integer viewId) {
        View view = this.getActiveView();
        if (view != null) {
            view.onDeactivate();
        }
        this.previousViewId = this.activeViewId;
        this.activeViewId = viewId;
        view = this.getActiveView();
        if (view == null) {
            throw new RuntimeException("Trying to activate view that does not exist: " + viewId);
        }
        view.onActivate();
        for (ViewChangeListener listener : this.viewChangeListeners) {
            listener.call(this.previousViewId, this.activeViewId);
        }
    }

    public Integer getActiveViewId() {
        return this.activeViewId;
    }

    public View getActiveView() {
        return this.activeViewId < 0 ? null : this.getView(this.activeViewId);
    }

    public boolean isActiveView(Integer viewId) {
        return this.activeViewId.equals(viewId);
    }

    public Integer getPreviousViewId() {
        return this.previousViewId;
    }

    public void setPreviousView(Integer viewId) {
        this.previousViewId = viewId;
    }

    public void restoreView() {
        this.setActiveView(this.previousViewId);
    }

    public void addViewChangeListener(ViewChangeListener listener) {
        this.viewChangeListeners.add(listener);
    }

    public void registerTriggerCommand(Integer commandID, TriggerCommand command) {
        this.views.forEach((viewID, view) -> view.registerTriggerCommand(commandID, command));
    }

    public void registerContinuousCommand(Integer commandID, ContinuousCommand command) {
        this.views.forEach((viewID, view) -> view.registerContinuousCommand(commandID, command));
    }

    public void registerNoteCommand(Integer commandID, TriggerCommand command) {
        this.views.forEach((viewID, view) -> view.registerNoteCommand(commandID, command));
    }

    public void registerPitchbendCommand(PitchbendCommand command) {
        this.views.forEach((viewID, view) -> view.registerPitchbendCommand(command));
    }

    public void registerAftertouchCommand(AftertouchCommand command) {
        this.views.forEach((viewID, view) -> view.registerAftertouchCommand(command));
    }

    public void setPreferredView(int position, Integer viewID) {
        if (position >= 0) {
            this.preferredViews.put(position, viewID);
        }
    }

    public Integer getPreferredView(int position) {
        return position >= 0 ? this.preferredViews.get(position) : null;
    }
}

