/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.command.core.AftertouchCommand;
import de.mossgrabers.framework.command.core.ContinuousCommand;
import de.mossgrabers.framework.command.core.PitchbendCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.Mode;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.View;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractView<S extends IControlSurface<C>, C extends Configuration>
implements View {
    private static final int[] EMPTY_TABLE = Scales.getEmptyMatrix();
    protected S surface;
    protected IModel model;
    private AftertouchCommand aftertouchCommand;
    private PitchbendCommand pitchbendCommand;
    private final Map<Integer, TriggerCommand> triggerCommands = new HashMap<Integer, TriggerCommand>();
    private final Map<Integer, TriggerCommand> noteCommands = new HashMap<Integer, TriggerCommand>();
    private final Map<Integer, ContinuousCommand> continuousCommands = new HashMap<Integer, ContinuousCommand>();
    protected boolean canScrollLeft;
    protected boolean canScrollRight;
    protected boolean canScrollUp;
    protected boolean canScrollDown;
    protected Scales scales;
    protected int[] noteMap;
    private final String name;

    public AbstractView(String name, S surface, IModel model) {
        this.name = name;
        this.surface = surface;
        this.model = model;
        this.canScrollLeft = true;
        this.canScrollRight = true;
        this.canScrollUp = true;
        this.canScrollDown = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onActivate() {
        this.updateNoteMapping();
    }

    @Override
    public void onDeactivate() {
    }

    @Override
    public void selectTrack(int index) {
        this.model.getCurrentTrackBank().getTrack(index).selectAndMakeVisible();
    }

    @Override
    public void updateControlSurface() {
        Mode m = this.surface.getModeManager().getActiveMode();
        if (m != null) {
            m.updateDisplay();
            m.updateFirstRow();
            m.updateSecondRow();
        }
        this.updateButtons();
        this.updateArrows();
    }

    @Override
    public boolean usesButton(int buttonID) {
        return true;
    }

    @Override
    public void registerAftertouchCommand(AftertouchCommand command) {
        this.aftertouchCommand = command;
    }

    @Override
    public void executeAftertouchCommand(int note, int value) {
        if (this.aftertouchCommand == null) {
            return;
        }
        if (note == -1) {
            this.aftertouchCommand.onChannelAftertouch(value);
        } else {
            this.aftertouchCommand.onPolyAftertouch(note, value);
        }
    }

    @Override
    public void registerPitchbendCommand(PitchbendCommand command) {
        this.pitchbendCommand = command;
    }

    @Override
    public void executePitchbendCommand(int channel, int data1, int data2) {
        if (this.pitchbendCommand != null) {
            this.pitchbendCommand.onPitchbend(channel, data1, data2);
        }
    }

    @Override
    public PitchbendCommand getPitchbendCommand() {
        return this.pitchbendCommand;
    }

    @Override
    public void onGridNoteLongPress(int note) {
    }

    @Override
    public void registerTriggerCommand(Integer commandID, TriggerCommand command) {
        this.triggerCommands.put(commandID, command);
    }

    @Override
    public void executeTriggerCommand(Integer commandID, ButtonEvent event) {
        TriggerCommand triggerCommand = this.triggerCommands.get(commandID);
        if (triggerCommand != null) {
            triggerCommand.execute(event);
        }
    }

    @Override
    public TriggerCommand getTriggerCommand(Integer commandID) {
        return this.triggerCommands.get(commandID);
    }

    @Override
    public void registerContinuousCommand(Integer commandID, ContinuousCommand command) {
        this.continuousCommands.put(commandID, command);
    }

    @Override
    public ContinuousCommand getContinuousCommand(Integer commandID) {
        return this.continuousCommands.get(commandID);
    }

    @Override
    public void executeContinuousCommand(Integer commandID, int value) {
        ContinuousCommand continuousCommand = this.continuousCommands.get(commandID);
        if (continuousCommand != null) {
            continuousCommand.execute(value);
        }
    }

    @Override
    public void registerNoteCommand(Integer commandID, TriggerCommand command) {
        this.noteCommands.put(commandID, command);
    }

    @Override
    public void executeNoteCommand(Integer commandID, int value) {
        TriggerCommand command = this.noteCommands.get(commandID);
        if (command != null) {
            command.execute(value == 0 ? ButtonEvent.UP : ButtonEvent.DOWN);
        }
    }

    @Override
    public TriggerCommand getNoteCommand(Integer commandID) {
        return this.noteCommands.get(commandID);
    }

    protected String getColor(int pad, ITrack track) {
        return AbstractView.replaceOctaveColorWithTrackColor(track, this.scales.getColor(this.noteMap, pad));
    }

    protected static String replaceOctaveColorWithTrackColor(ITrack track, String colorID) {
        if ("SCALE_COLOR_OCTAVE".equals(colorID)) {
            if (track == null) {
                return "SCALE_COLOR_OCTAVE";
            }
            double[] color = track.getColor();
            String c = DAWColors.getColorIndex(color[0], color[1], color[2]);
            return c == null ? "SCALE_COLOR_OCTAVE" : c;
        }
        return colorID;
    }

    protected void updateButtons() {
    }

    protected void updateArrows() {
    }

    @Override
    public void updateNoteMapping() {
        this.surface.setKeyTranslationTable(EMPTY_TABLE);
    }
}

