/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.SessionColor;

public abstract class AbstractSessionView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C>
implements SceneView {
    protected SessionColor clipColorIsRecording = new SessionColor(0, -1, false);
    protected SessionColor clipColorIsRecordingQueued = new SessionColor(1, -1, false);
    protected SessionColor clipColorIsPlaying = new SessionColor(2, -1, false);
    protected SessionColor clipColorIsPlayingQueued = new SessionColor(3, -1, false);
    protected SessionColor clipColorHasContent = new SessionColor(4, -1, false);
    protected SessionColor clipColorHasNoContent = new SessionColor(5, -1, false);
    protected SessionColor clipColorIsRecArmed = new SessionColor(6, -1, false);
    protected int rows;
    protected int columns;
    protected boolean useClipColor;

    public AbstractSessionView(String name, S surface, IModel model, int rows, int columns, boolean useClipColor) {
        super(name, surface, model);
        this.rows = rows;
        this.columns = columns;
        this.useClipColor = useClipColor;
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getCurrentTrackBank().launchScene(scene);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int index = note - 36;
        int t = index % this.columns;
        int s = this.rows - 1 - index / this.columns;
        Object configuration = this.surface.getConfiguration();
        if (configuration.isFlipSession()) {
            int dummy = t;
            t = s;
            s = dummy;
        }
        ITrack track = this.model.getCurrentTrackBank().getTrack(t);
        ISlot slot = track.getSlot(s);
        if (this.surface.isDeletePressed()) {
            this.surface.setButtonConsumed(this.surface.getDeleteButtonId());
            slot.delete();
            return;
        }
        if (this.surface.isSelectPressed()) {
            slot.select();
            return;
        }
        if (this.doSelectClipOnLaunch()) {
            slot.select();
        }
        if (!track.isRecArm()) {
            slot.launch();
            return;
        }
        if (slot.hasContent()) {
            slot.launch();
            return;
        }
        switch (configuration.getActionForRecArmedPad()) {
            case 0: {
                if (!slot.isRecording()) {
                    slot.record();
                }
                slot.launch();
                break;
            }
            case 1: {
                this.model.createClip(slot, this.surface.getConfiguration().getNewClipLength());
                slot.select();
                slot.launch();
                this.model.getTransport().setLauncherOverdub(true);
                break;
            }
        }
    }

    @Override
    public void drawGrid() {
        if (this.surface.isShiftPressed()) {
            this.drawBirdsEyeGrid();
        } else {
            this.drawSessionGrid();
        }
    }

    protected void drawSessionGrid() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        boolean flipSession = this.surface.getConfiguration().isFlipSession();
        for (int x = 0; x < this.columns; ++x) {
            ITrack t = tb.getTrack(x);
            for (int y = 0; y < this.rows; ++y) {
                this.drawPad(t.getSlot(y), flipSession ? y : x, flipSession ? x : y, t.isRecArm());
            }
        }
    }

    protected void drawBirdsEyeGrid() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        int numTracks = tb.getNumTracks();
        int numScenes = tb.getNumScenes();
        int sceneCount = this.model.getSceneBank().getSceneCount();
        int trackCount = tb.getTrackCount();
        int maxScenePads = sceneCount / numScenes + (sceneCount % numScenes > 0 ? 1 : 0);
        int maxTrackPads = trackCount / numTracks + (trackCount % numTracks > 0 ? 1 : 0);
        int scenePosition = tb.getScenePosition();
        int trackPosition = tb.getTrack(0).getPosition();
        int sceneSelection = scenePosition / numScenes + (scenePosition % numScenes > 0 ? 1 : 0);
        int trackSelection = trackPosition / numTracks + (trackPosition % numTracks > 0 ? 1 : 0);
        boolean flipSession = this.surface.getConfiguration().isFlipSession();
        int selX = flipSession ? sceneSelection : trackSelection;
        int selY = flipSession ? trackSelection : sceneSelection;
        int padsX = flipSession ? this.rows : this.columns;
        int padsY = flipSession ? this.columns : this.rows;
        int offsetX = selX / padsX * padsX;
        int offsetY = selY / padsY * padsY;
        int maxX = (flipSession ? maxScenePads : maxTrackPads) - offsetX;
        int maxY = (flipSession ? maxTrackPads : maxScenePads) - offsetY;
        selX -= offsetX;
        selY -= offsetY;
        for (int x = 0; x < this.columns; ++x) {
            SessionColor rowColor = x < maxX ? this.clipColorHasContent : this.clipColorHasNoContent;
            for (int y = 0; y < this.rows; ++y) {
                SessionColor color;
                SessionColor sessionColor = color = y < maxY ? rowColor : this.clipColorHasNoContent;
                if (selX == x && selY == y) {
                    color = this.clipColorIsPlaying;
                }
                this.surface.getPadGrid().lightEx(x, y, color.getColor(), color.getBlink(), color.isFast());
            }
        }
    }

    protected void setColors(SessionColor isRecording, SessionColor isRecordingQueued, SessionColor isPlaying, SessionColor isPlayingQueued, SessionColor hasContent, SessionColor noContent, SessionColor recArmed) {
        this.clipColorIsRecording = isRecording;
        this.clipColorIsRecordingQueued = isRecordingQueued;
        this.clipColorIsPlaying = isPlaying;
        this.clipColorIsPlayingQueued = isPlayingQueued;
        this.clipColorHasContent = hasContent;
        this.clipColorHasNoContent = noContent;
        this.clipColorIsRecArmed = recArmed;
    }

    protected boolean doSelectClipOnLaunch() {
        return this.surface.getConfiguration().isSelectClipOnLaunch();
    }

    protected void drawPad(ISlot slot, int x, int y, boolean isArmed) {
        SessionColor color = this.getPadColor(slot, isArmed);
        this.surface.getPadGrid().lightEx(x, y, color.getColor(), color.getBlink(), color.isFast());
    }

    protected SessionColor getPadColor(ISlot slot, boolean isArmed) {
        double[] slotColor = slot.getColor();
        String colorIndex = DAWColors.getColorIndex(slotColor[0], slotColor[1], slotColor[2]);
        ColorManager cm = this.model.getColorManager();
        if (slot.isRecordingQueued()) {
            return this.clipColorIsRecordingQueued;
        }
        if (slot.isRecording()) {
            if (this.useClipColor && colorIndex != null) {
                return new SessionColor(cm.getColor(colorIndex), this.clipColorIsRecording.getBlink(), this.clipColorIsRecording.isFast());
            }
            return this.clipColorIsRecording;
        }
        if (slot.isPlayingQueued()) {
            return this.clipColorIsPlayingQueued;
        }
        if (slot.isPlaying()) {
            if (this.useClipColor && colorIndex != null) {
                return new SessionColor(cm.getColor(colorIndex), this.clipColorIsPlaying.getBlink(), this.clipColorIsPlaying.isFast());
            }
            return this.clipColorIsPlaying;
        }
        if (slot.hasContent()) {
            if (this.useClipColor && colorIndex != null) {
                return new SessionColor(cm.getColor(colorIndex), this.clipColorHasContent.getBlink(), this.clipColorHasContent.isFast());
            }
            return this.clipColorHasContent;
        }
        return isArmed && this.surface.getConfiguration().isDrawRecordStripe() ? this.clipColorIsRecArmed : this.clipColorHasNoContent;
    }
}

