/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;

public abstract class AbstractSequencerView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C>
implements SceneView {
    public static final String COLOR_STEP_HILITE_NO_CONTENT = "COLOR_STEP_HILITE_NO_CONTENT";
    public static final String COLOR_STEP_HILITE_CONTENT = "COLOR_STEP_HILITE_CONTENT";
    public static final String COLOR_NO_CONTENT = "COLOR_NO_CONTENT";
    public static final String COLOR_CONTENT = "COLOR_CONTENT";
    public static final String COLOR_CONTENT_CONT = "COLOR_CONTENT_CONT";
    public static final String COLOR_PAGE = "COLOR_PAGE";
    public static final String COLOR_ACTIVE_PAGE = "COLOR_ACTIVE_PAGE";
    public static final String COLOR_SELECTED_PAGE = "COLOR_SELECTED_PAGE";
    protected static final double[] RESOLUTIONS = new double[]{1.0, 0.6666666666666666, 0.5, 0.3333333333333333, 0.25, 0.16666666666666666, 0.125, 0.08333333333333333};
    protected static final String[] RESOLUTION_TEXTS = new String[]{"1/4", "1/4t", "1/8", "1/8t", "1/16", "1/16t", "1/32", "1/32t"};
    protected int numSequencerRows;
    protected int selectedIndex;
    protected int offsetY;
    protected final Configuration configuration;
    protected final int clipRows;
    protected final int clipCols;

    public AbstractSequencerView(String name, S surface, IModel model, int clipRows, int clipCols) {
        this(name, surface, model, clipRows, clipCols, clipRows);
    }

    public AbstractSequencerView(String name, S surface, IModel model, int clipRows, int clipCols, int numSequencerRows) {
        super(name, surface, model);
        this.clipRows = clipRows;
        this.clipCols = clipCols;
        this.configuration = this.surface.getConfiguration();
        this.selectedIndex = 4;
        this.scales = this.model.getScales();
        this.offsetY = 0;
        this.numSequencerRows = numSequencerRows;
        this.model.getCursorClip(clipCols, clipRows);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        ICursorClip clip = this.getClip();
        clip.enableObservers(true);
        clip.setStepLength(RESOLUTIONS[this.selectedIndex]);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.getClip().enableObservers(false);
    }

    @Override
    public void onScene(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN || !this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        this.selectedIndex = 7 - index;
        this.getClip().setStepLength(RESOLUTIONS[this.selectedIndex]);
        this.surface.getDisplay().notify(RESOLUTION_TEXTS[this.selectedIndex]);
    }

    public void onLeft(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.getClip().scrollStepsPageBackwards();
        }
    }

    public void onRight(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.getClip().scrollStepsPageForward();
        }
    }

    public ICursorClip getClip() {
        return this.model.getCursorClip(this.clipCols, this.clipRows);
    }

    protected boolean isInXRange(int x) {
        ICursorClip clip = this.getClip();
        int stepSize = clip.getNumSteps();
        int start = clip.getEditPage() * stepSize;
        return x >= start && x < start + stepSize;
    }

    protected int getScrollOffset() {
        int pos = this.numSequencerRows;
        return pos / 7 * 12 + this.noteMap[pos % 7] - this.noteMap[0];
    }

    protected int getLengthOfOnePage(int numOfSteps) {
        return (int)Math.floor((double)numOfSteps * RESOLUTIONS[this.selectedIndex]);
    }

    protected String getPageColor(int loopStartPage, int loopEndPage, int playPage, int selectedPage, int page) {
        if (page == playPage) {
            return COLOR_ACTIVE_PAGE;
        }
        if (page == selectedPage) {
            return COLOR_SELECTED_PAGE;
        }
        if (page < loopStartPage || page >= loopEndPage) {
            return COLOR_NO_CONTENT;
        }
        return COLOR_PAGE;
    }
}

