/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSequencerView;
import de.mossgrabers.framework.view.TransposeView;

public abstract class AbstractRaindropsView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractSequencerView<S, C>
implements TransposeView {
    protected static final int NUM_DISPLAY_COLS = 8;
    protected static final int NUM_OCTAVE = 12;
    protected static final int START_KEY = 36;
    protected int numDisplayRows = 8;
    protected boolean ongoingResolutionChange;
    private boolean useTrackColor;

    public AbstractRaindropsView(String name, S surface, IModel model, boolean useTrackColor) {
        super(name, surface, model, 128, 512);
        this.useTrackColor = useTrackColor;
        this.offsetY = 36;
        this.getClip().scrollTo(0, 36);
        this.canScrollUp = false;
        this.canScrollDown = false;
        this.ongoingResolutionChange = false;
    }

    @Override
    public void onActivate() {
        this.updateScale();
        super.onActivate();
    }

    @Override
    public void updateNoteMapping() {
        super.updateNoteMapping();
        this.updateScale();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        if (velocity == 0) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        int stepSize = y == 0 ? 1 : 2 * y;
        ICursorClip clip = this.getClip();
        int length = (int)Math.floor(clip.getLoopLength() / RESOLUTIONS[this.selectedIndex]);
        int distance = this.getNoteDistance(this.noteMap[x], length);
        clip.clearRow(this.noteMap[x]);
        if (distance == -1 || distance != (y == 0 ? 1 : y * 2)) {
            int offset;
            for (int i = offset = clip.getCurrentStep() % stepSize; i < length; i += stepSize) {
                clip.setStep(i, this.noteMap[x], this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity, RESOLUTIONS[this.selectedIndex]);
            }
        }
    }

    @Override
    public void drawGrid() {
        if (!this.model.canSelectedTrackHoldNotes()) {
            this.surface.getPadGrid().turnOff();
            return;
        }
        if (this.ongoingResolutionChange) {
            return;
        }
        ITrack selectedTrack = this.useTrackColor ? this.model.getSelectedTrack() : null;
        int length = (int)Math.floor(this.getClip().getLoopLength() / RESOLUTIONS[this.selectedIndex]);
        int step = this.getClip().getCurrentStep();
        for (int x = 0; x < 8; ++x) {
            int left = this.getNoteDistanceToTheLeft(this.noteMap[x], step, length);
            int right = this.getNoteDistanceToTheRight(this.noteMap[x], step, length);
            boolean isOn = left >= 0 && right >= 0;
            int sum = left + right;
            int distance = sum == 0 ? 0 : (sum + 1) / 2;
            for (int y = 0; y < this.numDisplayRows; ++y) {
                String colorID;
                String string = colorID = y == 0 ? this.getColor(x, selectedTrack) : "COLOR_NO_CONTENT";
                if (isOn) {
                    if (y == distance) {
                        colorID = "COLOR_CONTENT";
                    }
                    if (left <= distance && y == left || left > distance && y == sum - left) {
                        colorID = "COLOR_STEP_HILITE_NO_CONTENT";
                    }
                }
                this.surface.getPadGrid().lightEx(x, this.numDisplayRows - 1 - y, colorID);
            }
        }
    }

    @Override
    public void onScene(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.ongoingResolutionChange = true;
        super.onScene(index, event);
        this.ongoingResolutionChange = false;
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.offsetY = Math.max(0, this.offsetY - 12);
        this.updateScale();
        this.surface.getDisplay().notify(Scales.getSequencerRangeText(this.noteMap[0], this.noteMap[7]), true, true);
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.offsetY = Math.min(this.getClip().getNumRows() - 12, this.offsetY + 12);
        this.updateScale();
        this.surface.getDisplay().notify(Scales.getSequencerRangeText(this.noteMap[0], this.noteMap[7]), true, true);
    }

    protected int getNoteDistance(int row, int length) {
        int step;
        for (step = 0; step < length && this.getClip().getStep(step, row) <= 0; ++step) {
        }
        if (step >= length) {
            return -1;
        }
        for (int step2 = step + 1; step2 < length; ++step2) {
            if (this.getClip().getStep(step2, row) <= 0) continue;
            return step2 - step;
        }
        return -1;
    }

    protected int getNoteDistanceToTheRight(int row, int start, int length) {
        if (start < 0 || start >= length) {
            return -1;
        }
        int step = start;
        int counter = 0;
        do {
            if (this.getClip().getStep(step, row) > 0) {
                return counter;
            }
            ++counter;
            if (++step < length) continue;
            step = 0;
        } while (step != start);
        return -1;
    }

    protected int getNoteDistanceToTheLeft(int row, int start, int length) {
        int s;
        if (start < 0 || start >= length) {
            return -1;
        }
        int step = s = start == 0 ? length - 1 : start - 1;
        int counter = 0;
        do {
            if (this.getClip().getStep(step, row) > 0) {
                return counter;
            }
            ++counter;
            if (--step >= 0) continue;
            step = length - 1;
        } while (step != s);
        return -1;
    }

    protected void updateScale() {
        this.noteMap = this.model.canSelectedTrackHoldNotes() ? this.scales.getSequencerMatrix(8, this.offsetY) : Scales.getEmptyMatrix();
    }
}

