/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.TransposeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractPlayView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C>
implements TransposeView {
    public static final String COLOR_PLAY = "PLAY_VIEW_COLOR_PLAY";
    public static final String COLOR_RECORD = "PLAY_VIEW_COLOR_RECORD";
    public static final String COLOR_OFF = "PLAY_VIEW_COLOR_OFF";
    protected int[] pressedKeys;
    protected int[] defaultVelocity;
    private boolean useTrackColor;

    public AbstractPlayView(S surface, IModel model, boolean useTrackColor) {
        this("Play", surface, model, useTrackColor);
    }

    public AbstractPlayView(String name, S surface, IModel model, boolean useTrackColor) {
        super(name, surface, model);
        this.useTrackColor = useTrackColor;
        this.scales = model.getScales();
        this.noteMap = Scales.getEmptyMatrix();
        this.pressedKeys = new int[128];
        Arrays.fill(this.pressedKeys, 0);
        this.defaultVelocity = new int[128];
        for (int i = 0; i < 128; ++i) {
            this.defaultVelocity[i] = i;
        }
        ITrackBank tb = model.getTrackBank();
        tb.addNoteObserver(this::setPressedKeys);
        tb.addTrackSelectionObserver((index, isSelected) -> this.clearPressedKeys());
    }

    @Override
    public void drawGrid() {
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        boolean isRecording = this.model.hasRecordingState();
        ITrack selectedTrack = this.model.getSelectedTrack();
        PadGrid gridPad = this.surface.getPadGrid();
        for (int i = this.scales.getStartNote(); i < this.scales.getEndNote(); ++i) {
            gridPad.light(i, this.getGridColor(isKeyboardEnabled, isRecording, selectedTrack, i));
        }
    }

    protected String getGridColor(boolean isKeyboardEnabled, boolean isRecording, ITrack track, int note) {
        if (isKeyboardEnabled) {
            if (this.pressedKeys[note] > 0) {
                return isRecording ? COLOR_RECORD : COLOR_PLAY;
            }
            return this.getColor(note, this.useTrackColor ? track : null);
        }
        return COLOR_OFF;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes() || this.noteMap[note] == -1) {
            return;
        }
        this.setPressedKeys(this.noteMap[note], velocity);
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.clearPressedKeys();
        this.scales.decOctave();
        this.updateNoteMapping();
        this.surface.getDisplay().notify(this.scales.getRangeText(), true, true);
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.clearPressedKeys();
        this.scales.incOctave();
        this.updateNoteMapping();
        this.surface.getDisplay().notify(this.scales.getRangeText(), true, true);
    }

    public int getMidiNoteFromGrid(int note) {
        PadGrid padGrid = this.surface.getPadGrid();
        if (padGrid == null) {
            return -1;
        }
        int translated = padGrid.translateToGrid(note);
        return translated < 0 ? -1 : this.noteMap[translated];
    }

    protected void clearPressedKeys() {
        for (int i = 0; i < 128; ++i) {
            this.pressedKeys[i] = 0;
        }
    }

    protected void setPressedKeys(int note, int velocity) {
        for (int i = 0; i < 128; ++i) {
            if (this.noteMap[i] != note) continue;
            this.pressedKeys[i] = velocity;
        }
    }

    public List<Integer> getPressedKeys() {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (int i = 0; i < 128; ++i) {
            if (this.pressedKeys[i] == 0) continue;
            keys.add(i);
        }
        return keys;
    }

    @Override
    public void updateNoteMapping() {
        this.surface.scheduleTask(this::delayedUpdateNoteMapping, 100L);
    }

    private void delayedUpdateNoteMapping() {
        this.noteMap = this.model.canSelectedTrackHoldNotes() ? this.scales.getNoteMatrix() : Scales.getEmptyMatrix();
        this.surface.setKeyTranslationTable(this.scales.translateMatrixToGrid(this.noteMap));
    }
}

