/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSequencerView;
import de.mossgrabers.framework.view.TransposeView;

public abstract class AbstractNoteSequencerView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractSequencerView<S, C>
implements TransposeView {
    protected int numDisplayRows = 8;
    protected int numDisplayCols;
    protected int startKey = 36;
    protected int loopPadPressed = -1;
    private boolean useTrackColor;

    public AbstractNoteSequencerView(String name, S surface, IModel model, boolean useTrackColor) {
        this(name, surface, model, 8, useTrackColor);
    }

    public AbstractNoteSequencerView(String name, S surface, IModel model, int numDisplayCols, boolean useTrackColor) {
        super(name, surface, model, 128, numDisplayCols, 7);
        this.useTrackColor = useTrackColor;
        this.numDisplayCols = numDisplayCols;
        this.offsetY = this.startKey;
    }

    @Override
    public void onActivate() {
        this.updateScale();
        super.onActivate();
        this.getClip().scrollTo(0, this.offsetY);
    }

    @Override
    public void updateNoteMapping() {
        super.updateNoteMapping();
        this.updateScale();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        ICursorClip clip = this.getClip();
        if (y < this.numSequencerRows) {
            if (velocity != 0) {
                clip.toggleStep(x, this.noteMap[y], this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
            }
            return;
        }
        int pad = x;
        if (velocity > 0) {
            if (this.loopPadPressed == -1) {
                this.loopPadPressed = pad;
            }
            return;
        }
        if (this.loopPadPressed == -1) {
            return;
        }
        if (pad == this.loopPadPressed && pad != clip.getEditPage()) {
            clip.scrollToPage(pad);
        } else {
            int start = this.loopPadPressed < pad ? this.loopPadPressed : pad;
            int end = (this.loopPadPressed < pad ? pad : this.loopPadPressed) + 1;
            int lengthOfOnePad = this.getLengthOfOnePage(this.numDisplayCols);
            double newStart = start * lengthOfOnePad;
            clip.setLoopStart(newStart);
            clip.setLoopLength((end - start) * lengthOfOnePad);
            clip.setPlayRange(newStart, (double)end * (double)lengthOfOnePad);
        }
        this.loopPadPressed = -1;
    }

    @Override
    public void drawGrid() {
        PadGrid gridPad = this.surface.getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            gridPad.turnOff();
            return;
        }
        ITrack selectedTrack = this.model.getSelectedTrack();
        ICursorClip clip = this.getClip();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.numDisplayCols : -1;
        for (int x = 0; x < this.numDisplayCols; ++x) {
            for (int y = 0; y < this.numSequencerRows; ++y) {
                int isSet = clip.getStep(x, this.noteMap[y]);
                gridPad.lightEx(x, this.numDisplayRows - 1 - y, this.getStepColor(isSet, x == hiStep, y, selectedTrack));
            }
        }
        if (this.numDisplayRows - this.numSequencerRows <= 0) {
            return;
        }
        int lengthOfOnePad = this.getLengthOfOnePage(this.numDisplayCols);
        double loopStart = clip.getLoopStart();
        int loopStartPad = (int)Math.ceil(loopStart / (double)lengthOfOnePad);
        int loopEndPad = (int)Math.ceil((loopStart + clip.getLoopLength()) / (double)lengthOfOnePad);
        int currentPage = step / this.numDisplayCols;
        for (int pad = 0; pad < 8; ++pad) {
            gridPad.lightEx(pad, 0, this.getPageColor(loopStartPad, loopEndPad, currentPage, clip.getEditPage(), pad));
        }
    }

    protected String getStepColor(int isSet, boolean hilite, int note, ITrack track) {
        switch (isSet) {
            case 1: {
                return hilite ? "COLOR_STEP_HILITE_CONTENT" : "COLOR_CONTENT_CONT";
            }
            case 2: {
                return hilite ? "COLOR_STEP_HILITE_CONTENT" : "COLOR_CONTENT";
            }
        }
        return hilite ? "COLOR_STEP_HILITE_NO_CONTENT" : this.getColor(note, this.useTrackColor ? track : null);
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.updateOctave(Math.max(0, this.offsetY - this.getScrollOffset()));
        }
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        int offset = this.getScrollOffset();
        if (this.offsetY + offset < this.getClip().getNumRows()) {
            this.updateOctave(this.offsetY + offset);
        }
    }

    protected void updateScale() {
        this.noteMap = this.model.canSelectedTrackHoldNotes() ? this.scales.getSequencerMatrix(8, this.offsetY) : Scales.getEmptyMatrix();
    }

    protected void updateOctave(int value) {
        this.offsetY = value;
        this.updateScale();
        this.surface.getDisplay().notify(Scales.getSequencerRangeText(this.noteMap[0], this.noteMap[this.numSequencerRows - 1]), true, true);
    }
}

