/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.TransposeView;

public abstract class AbstractDrumView64<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C>
implements SceneView,
TransposeView {
    protected static final int DRUM_START_KEY = 36;
    protected static final int GRID_COLUMNS = 8;
    protected static final int[] DRUM_MATRIX = new int[]{0, 1, 2, 3, 32, 33, 34, 35, 4, 5, 6, 7, 36, 37, 38, 39, 8, 9, 10, 11, 40, 41, 42, 43, 12, 13, 14, 15, 44, 45, 46, 47, 16, 17, 18, 19, 48, 49, 50, 51, 20, 21, 22, 23, 52, 53, 54, 55, 24, 25, 26, 27, 56, 57, 58, 59, 28, 29, 30, 31, 60, 61, 62, 63};
    protected int offsetY = 36;
    protected int selectedPad = 0;
    protected int[] pressedKeys = new int[128];
    protected int columns;
    protected int rows;
    protected int drumOctave;

    public AbstractDrumView64(S surface, IModel model) {
        super("Drum 64", surface, model);
        this.canScrollUp = false;
        this.canScrollDown = false;
        this.scales = this.model.getScales();
        this.noteMap = Scales.getEmptyMatrix();
        this.columns = 8;
        this.rows = 8;
        this.drumOctave = 0;
        ITrackBank tb = model.getTrackBank();
        tb.addNoteObserver((note, velocity) -> {
            this.pressedKeys[note] = velocity;
        });
        tb.addTrackSelectionObserver((index, isSelected) -> this.clearPressedKeys());
    }

    @Override
    public void onScene(int index, ButtonEvent event) {
    }

    @Override
    public void onActivate() {
        super.onActivate();
        ICursorDevice drumDevice64 = this.model.getDrumDevice64();
        drumDevice64.enableObservers(true);
        drumDevice64.setDrumPadIndication(true);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        ICursorDevice drumDevice64 = this.model.getDrumDevice64();
        drumDevice64.enableObservers(false);
        drumDevice64.setDrumPadIndication(false);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        int x = index % this.columns;
        int y = index / this.columns;
        this.selectedPad = (x >= 4 ? 32 : 0) + y * 4 + x % 4;
        int playedPad = velocity == 0 ? -1 : this.selectedPad;
        this.pressedKeys[this.offsetY + this.selectedPad] = velocity;
        if (playedPad < 0) {
            return;
        }
        this.handleButtonCombinations(playedPad);
    }

    @Override
    public void drawGrid() {
        if (!this.model.canSelectedTrackHoldNotes()) {
            this.surface.getPadGrid().turnOff();
            return;
        }
        ICursorDevice drumDevice64 = this.model.getDrumDevice64();
        boolean hasDrumPads = drumDevice64.hasDrumPads();
        boolean isSoloed = false;
        int numPads = this.rows * this.columns;
        if (hasDrumPads) {
            for (int i = 0; i < numPads; ++i) {
                if (!drumDevice64.getDrumPad(i).isSolo()) continue;
                isSoloed = true;
                break;
            }
        }
        boolean isRecording = this.model.hasRecordingState();
        for (int index = 0; index < numPads; ++index) {
            int x = index / 32 * 4 + index % 4;
            int y = index / 4 % 8;
            this.surface.getPadGrid().lightEx(x, 7 - y, this.getPadColor(index, drumDevice64, isSoloed, isRecording));
        }
    }

    private String getPadColor(int index, ICursorDevice primary, boolean isSoloed, boolean isRecording) {
        if (this.pressedKeys[this.offsetY + index] > 0) {
            return isRecording ? "COLOR_PAD_RECORD" : "COLOR_PAD_PLAY";
        }
        if (this.selectedPad == index) {
            return "COLOR_PAD_SELECTED";
        }
        IDrumPad drumPad = primary.getDrumPad(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return this.surface.getConfiguration().isTurnOffEmptyDrumPads() ? "COLOR_PAD_OFF" : "COLOR_PAD_NO_CONTENT";
        }
        if (drumPad.isMute() || isSoloed && !drumPad.isSolo()) {
            return "COLOR_PAD_MUTED";
        }
        return this.getPadContentColor(drumPad);
    }

    protected String getPadContentColor(IChannel drumPad) {
        return DAWColors.getColorIndex(drumPad.getColor());
    }

    private void clearPressedKeys() {
        for (int i = 0; i < 128; ++i) {
            this.pressedKeys[i] = 0;
        }
    }

    @Override
    public void updateNoteMapping() {
        boolean turnOn = this.model.canSelectedTrackHoldNotes() && !this.surface.isSelectPressed() && !this.surface.isDeletePressed() && !this.surface.isMutePressed() && !this.surface.isSoloPressed();
        this.noteMap = turnOn ? this.getDrumMatrix() : Scales.getEmptyMatrix();
        this.surface.setKeyTranslationTable(this.scales.translateMatrixToGrid(this.noteMap));
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.clearPressedKeys();
        int oldDrumOctave = this.drumOctave;
        this.drumOctave = Math.max(-2, this.drumOctave - 1);
        this.offsetY = 36 + this.drumOctave * 16;
        this.updateNoteMapping();
        this.surface.getDisplay().notify(this.getDrumRangeText(), true, true);
        if (oldDrumOctave != this.drumOctave) {
            ICursorDevice drumDevice64 = this.model.getDrumDevice64();
            for (int i = 0; i < 16; ++i) {
                drumDevice64.scrollDrumPadsUp();
            }
        }
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.clearPressedKeys();
        int oldDrumOctave = this.drumOctave;
        this.drumOctave = Math.min(1, this.drumOctave + 1);
        this.offsetY = 36 + this.drumOctave * 16;
        this.updateNoteMapping();
        this.surface.getDisplay().notify(this.getDrumRangeText(), true, true);
        if (oldDrumOctave != this.drumOctave) {
            ICursorDevice drumDevice64 = this.model.getDrumDevice64();
            for (int i = 0; i < 16; ++i) {
                drumDevice64.scrollDrumPadsDown();
            }
        }
    }

    private void handleButtonCombinations(int playedPad) {
        if (this.surface.isDeletePressed()) {
            this.handleDeleteButton(playedPad);
        } else if (this.surface.isMutePressed()) {
            this.handleMuteButton(playedPad);
        } else if (this.surface.isSoloPressed()) {
            this.handleSoloButton(playedPad);
        } else if (this.surface.isSelectPressed() || this.surface.getConfiguration().isAutoSelectDrum()) {
            this.handleSelectButton(playedPad);
        }
        this.updateNoteMapping();
    }

    protected void handleDeleteButton(int playedPad) {
    }

    protected void handleMuteButton(int playedPad) {
        this.surface.setButtonConsumed(this.surface.getMuteButtonId());
        this.model.getDrumDevice64().toggleLayerOrDrumPadMute(playedPad);
    }

    protected void handleSoloButton(int playedPad) {
        this.surface.setButtonConsumed(this.surface.getSoloButtonId());
        this.model.getDrumDevice64().toggleLayerOrDrumPadSolo(playedPad);
    }

    protected void handleSelectButton(int playedPad) {
    }

    private int[] getDrumMatrix() {
        int[] matrix = DRUM_MATRIX;
        this.noteMap = Scales.getEmptyMatrix();
        for (int i = 0; i < 64; ++i) {
            int n = matrix[i] == -1 ? -1 : matrix[i] + 36 + this.drumOctave * 16;
            this.noteMap[36 + i] = n < 0 || n > 127 ? -1 : n;
        }
        return this.noteMap;
    }

    private String getDrumRangeText() {
        int s = 36 + this.drumOctave * 64;
        return Scales.formatDrumNote(s) + " to " + Scales.formatDrumNote(s + 63);
    }

    public int getDrumOctave() {
        return this.drumOctave;
    }
}

