/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSequencerView;
import de.mossgrabers.framework.view.TransposeView;
import java.util.Arrays;

public abstract class AbstractDrumView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractSequencerView<S, C>
implements TransposeView {
    public static final String COLOR_PAD_RECORD = "COLOR_PAD_RECORD";
    public static final String COLOR_PAD_PLAY = "COLOR_PAD_PLAY";
    public static final String COLOR_PAD_SELECTED = "COLOR_PAD_SELECTED";
    public static final String COLOR_PAD_MUTED = "COLOR_PAD_MUTED";
    public static final String COLOR_PAD_HAS_CONTENT = "COLOR_PAD_HAS_CONTENT";
    public static final String COLOR_PAD_NO_CONTENT = "COLOR_PAD_NO_CONTENT";
    public static final String COLOR_PAD_OFF = "COLOR_PAD_OFF";
    static final int DRUM_START_KEY = 36;
    static final int GRID_COLUMNS = 8;
    protected int selectedPad;
    private int loopPadPressed = -1;
    private int sequencerLines;
    private int playLines;
    private int allLines;
    private int sequencerSteps;
    private int halfColumns;
    private int[] pressedKeys;

    public AbstractDrumView(String name, S surface, IModel model, int numSequencerLines, int numPlayLines) {
        super(name, surface, model, 128, numSequencerLines * 8);
        this.sequencerLines = numSequencerLines;
        this.playLines = numPlayLines;
        this.allLines = this.sequencerLines + this.playLines;
        this.sequencerSteps = numSequencerLines * 8;
        this.halfColumns = 4;
        this.offsetY = 36;
        this.canScrollUp = false;
        this.canScrollDown = false;
        this.pressedKeys = new int[128];
        Arrays.fill(this.pressedKeys, 0);
        this.noteMap = Scales.getEmptyMatrix();
        ITrackBank tb = model.getTrackBank();
        tb.addNoteObserver((note, velocity) -> {
            this.pressedKeys[note] = velocity;
        });
        tb.addTrackSelectionObserver((index, isSelected) -> this.clearPressedKeys());
    }

    @Override
    public void onActivate() {
        super.onActivate();
        ICursorDevice primary = this.model.getPrimaryDevice();
        primary.enableObservers(true);
        primary.setDrumPadIndication(true);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        ICursorDevice primary = this.model.getPrimaryDevice();
        primary.enableObservers(false);
        primary.setDrumPadIndication(false);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        ICursorClip clip = this.getClip();
        if (y >= this.playLines) {
            if (velocity != 0) {
                int col = 8 * (this.allLines - 1 - y) + x;
                clip.toggleStep(col, this.offsetY + this.selectedPad, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
            }
            return;
        }
        if (x < this.halfColumns) {
            this.selectedPad = this.halfColumns * y + x;
            int playedPad = velocity == 0 ? -1 : this.selectedPad;
            this.pressedKeys[this.offsetY + this.selectedPad] = velocity;
            this.playNote(this.offsetY + this.selectedPad, velocity);
            if (playedPad < 0) {
                return;
            }
            this.handleButtonCombinations(playedPad);
            return;
        }
        int pad = (this.playLines - 1 - y) * this.halfColumns + x - this.halfColumns;
        if (velocity > 0) {
            if (this.loopPadPressed == -1) {
                this.loopPadPressed = pad;
            }
            return;
        }
        if (this.loopPadPressed == -1) {
            return;
        }
        if (pad == this.loopPadPressed && pad != clip.getEditPage()) {
            clip.scrollToPage(pad);
        } else {
            int start = this.loopPadPressed < pad ? this.loopPadPressed : pad;
            int end = (this.loopPadPressed < pad ? pad : this.loopPadPressed) + 1;
            int lengthOfOnePad = this.getLengthOfOnePage(this.sequencerSteps);
            int newStart = start * lengthOfOnePad;
            clip.setLoopStart(newStart);
            clip.setLoopLength((end - start) * lengthOfOnePad);
            clip.setPlayRange(newStart, (double)end * (double)lengthOfOnePad);
        }
        this.loopPadPressed = -1;
    }

    @Override
    public void drawGrid() {
        PadGrid padGrid = this.surface.getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            padGrid.turnOff();
            return;
        }
        ICursorDevice primary = this.model.getPrimaryDevice();
        boolean hasDrumPads = primary.hasDrumPads();
        boolean isSoloed = false;
        if (hasDrumPads) {
            for (int i = 0; i < this.halfColumns * this.playLines; ++i) {
                if (!primary.getDrumPad(i).isSolo()) continue;
                isSoloed = true;
                break;
            }
        }
        boolean isRecording = this.model.hasRecordingState();
        for (int y = 0; y < this.playLines; ++y) {
            for (int x = 0; x < this.halfColumns; ++x) {
                int index = this.halfColumns * y + x;
                padGrid.lightEx(x, this.allLines - 1 - y, this.getPadColor(index, primary, isSoloed, isRecording));
            }
        }
        this.drawSequencer();
    }

    protected String getPadColor(int index, ICursorDevice primary, boolean isSoloed, boolean isRecording) {
        if (this.pressedKeys[this.offsetY + index] > 0) {
            return isRecording ? COLOR_PAD_RECORD : COLOR_PAD_PLAY;
        }
        if (this.selectedPad == index) {
            return COLOR_PAD_SELECTED;
        }
        IDrumPad drumPad = primary.getDrumPad(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return this.surface.getConfiguration().isTurnOffEmptyDrumPads() ? COLOR_PAD_OFF : COLOR_PAD_NO_CONTENT;
        }
        if (drumPad.isMute() || isSoloed && !drumPad.isSolo()) {
            return COLOR_PAD_MUTED;
        }
        return this.getPadContentColor(drumPad);
    }

    protected String getPadContentColor(IChannel drumPad) {
        return DAWColors.getColorIndex(drumPad.getColor());
    }

    protected String getStepColor(int isSet, boolean hilite) {
        switch (isSet) {
            case 1: {
                return hilite ? "COLOR_STEP_HILITE_CONTENT" : "COLOR_CONTENT_CONT";
            }
            case 2: {
                return hilite ? "COLOR_STEP_HILITE_CONTENT" : "COLOR_CONTENT";
            }
        }
        return hilite ? "COLOR_STEP_HILITE_NO_CONTENT" : "COLOR_NO_CONTENT";
    }

    protected void clearPressedKeys() {
        for (int i = 0; i < 128; ++i) {
            this.pressedKeys[i] = 0;
        }
    }

    @Override
    public void updateNoteMapping() {
        this.noteMap = this.canPadsBeTurnedOn() ? this.scales.getDrumMatrix() : Scales.getEmptyMatrix();
        this.surface.setKeyTranslationTable(this.scales.translateMatrixToGrid(this.noteMap));
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.clearPressedKeys();
        int oldDrumOctave = this.scales.getDrumOctave();
        this.scales.decDrumOctave();
        int newDrumOctave = this.scales.getDrumOctave();
        this.offsetY = 36 + newDrumOctave * 16;
        this.updateNoteMapping();
        this.surface.getDisplay().notify(this.scales.getDrumRangeText(), true, true);
        if (oldDrumOctave != newDrumOctave) {
            this.model.getPrimaryDevice().scrollDrumPadsPageUp();
        }
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.clearPressedKeys();
        int oldDrumOctave = this.scales.getDrumOctave();
        this.scales.incDrumOctave();
        int newDrumOctave = this.scales.getDrumOctave();
        this.offsetY = 36 + newDrumOctave * 16;
        this.updateNoteMapping();
        this.surface.getDisplay().notify(this.scales.getDrumRangeText(), true, true);
        if (oldDrumOctave != newDrumOctave) {
            this.model.getPrimaryDevice().scrollDrumPadsPageDown();
        }
    }

    protected void playNote(int note, int velocity) {
    }

    protected void handleButtonCombinations(int playedPad) {
        if (this.surface.isDeletePressed()) {
            this.handleDeleteButton(playedPad);
            return;
        }
        if (this.surface.isMutePressed()) {
            this.handleMuteButton(playedPad);
            return;
        }
        if (this.surface.isSoloPressed()) {
            this.handleSoloButton(playedPad);
            return;
        }
        if (this.surface.isSelectPressed() || this.configuration.isAutoSelectDrum()) {
            this.handleSelectButton(playedPad);
        }
    }

    protected void handleDeleteButton(int playedPad) {
        this.surface.setButtonConsumed(this.surface.getDeleteButtonId());
        this.updateNoteMapping();
        this.getClip().clearRow(this.offsetY + playedPad);
    }

    protected void handleMuteButton(int playedPad) {
        this.surface.setButtonConsumed(this.surface.getMuteButtonId());
        this.updateNoteMapping();
        this.model.getPrimaryDevice().toggleLayerOrDrumPadMute(playedPad);
    }

    protected void handleSoloButton(int playedPad) {
        this.surface.setButtonConsumed(this.surface.getSoloButtonId());
        this.updateNoteMapping();
        this.model.getPrimaryDevice().toggleLayerOrDrumPadSolo(playedPad);
    }

    protected void handleSelectButton(int playedPad) {
    }

    private boolean canPadsBeTurnedOn() {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return false;
        }
        if (this.surface.isSelectPressed() && !this.surface.isButtonConsumed(this.surface.getSelectButtonId())) {
            return false;
        }
        if (this.surface.isDeletePressed() && !this.surface.isButtonConsumed(this.surface.getDeleteButtonId())) {
            return false;
        }
        if (this.surface.isMutePressed() && !this.surface.isButtonConsumed(this.surface.getMuteButtonId())) {
            return false;
        }
        return !this.surface.isSoloPressed() || this.surface.isButtonConsumed(this.surface.getSoloButtonId());
    }

    private void drawSequencer() {
        ICursorClip clip = this.getClip();
        int step = clip.getCurrentStep();
        int lengthOfOnePad = this.getLengthOfOnePage(this.sequencerSteps);
        double loopStart = clip.getLoopStart();
        int loopStartPad = (int)Math.ceil(loopStart / (double)lengthOfOnePad);
        int loopEndPad = (int)Math.ceil((loopStart + clip.getLoopLength()) / (double)lengthOfOnePad);
        int currentPage = step / this.sequencerSteps;
        int numOfPages = this.halfColumns * this.playLines;
        PadGrid padGrid = this.surface.getPadGrid();
        for (int pad = 0; pad < numOfPages; ++pad) {
            int x = this.halfColumns + pad % this.halfColumns;
            int y = this.sequencerLines + pad / this.halfColumns;
            padGrid.lightEx(x, y, this.getPageColor(loopStartPad, loopEndPad, currentPage, clip.getEditPage(), pad));
        }
        int hiStep = this.isInXRange(step) ? step % this.sequencerSteps : -1;
        for (int col = 0; col < this.sequencerSteps; ++col) {
            int isSet = clip.getStep(col, this.offsetY + this.selectedPad);
            boolean hilite = col == hiStep;
            int x = col % 8;
            int y = col / 8;
            padGrid.lightEx(x, y, this.getStepColor(isSet, hilite));
        }
    }
}

