/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.utils;

public class StringUtils {
    private static final char[] REMOVABLE_CHARS = new char[]{' ', 'e', 'a', 'u', 'i', 'o'};

    private StringUtils() {
    }

    public static String shortenAndFixASCII(String text, int length) {
        return StringUtils.optimizeName(StringUtils.fixASCII(text), length);
    }

    public static String fixASCII(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c > '\u007f') {
                switch (c) {
                    case '\u00c4': {
                        str.append("Ae");
                        break;
                    }
                    case '\u00e4': {
                        str.append("ae");
                        break;
                    }
                    case '\u00d6': 
                    case '\u0152': {
                        str.append("Oe");
                        break;
                    }
                    case '\u00f6': 
                    case '\u0153': {
                        str.append("oe");
                        break;
                    }
                    case '\u00dc': {
                        str.append("Ue");
                        break;
                    }
                    case '\u00fc': {
                        str.append("ue");
                        break;
                    }
                    case '\u00df': {
                        str.append("ss");
                        break;
                    }
                    case '\u00e9': {
                        str.append("e");
                        break;
                    }
                    case '\u2192': {
                        str.append("->");
                        break;
                    }
                    default: {
                        str.append("?");
                        break;
                    }
                }
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    public static String optimizeName(String text, int length) {
        if (text == null) {
            return "";
        }
        String shortened = text;
        for (char element : REMOVABLE_CHARS) {
            int pos;
            if (shortened.length() <= length) {
                return shortened;
            }
            while ((pos = shortened.indexOf(element)) != -1) {
                if ((shortened = shortened.substring(0, pos) + shortened.substring(pos + 1, shortened.length())).length() > length) continue;
                return shortened;
            }
        }
        return shortened.length() <= length ? shortened : shortened.substring(0, length);
    }

    public static String toHexStr(int[] data) {
        StringBuilder sysex = new StringBuilder();
        for (int d : data) {
            sysex.append(StringUtils.toHexStr(d)).append(' ');
        }
        return sysex.toString();
    }

    public static String toHexStr(byte[] data) {
        StringBuilder sysex = new StringBuilder();
        for (byte d : data) {
            sysex.append(StringUtils.toHexStr(Byte.toUnsignedInt(d))).append(' ');
        }
        return sysex.toString();
    }

    public static String toHexStr(int number) {
        String v = Integer.toHexString(number).toUpperCase();
        return v.length() < 2 ? '0' + v : v;
    }

    public static String formatMeasures(int quartersPerMeasure, double time, int startOffset) {
        int measure = (int)Math.floor(time / (double)quartersPerMeasure);
        double t = time - (double)(measure * quartersPerMeasure);
        int quarters = (int)Math.floor(t);
        int eights = (int)Math.floor((t -= (double)quarters) / 0.25);
        return measure + startOffset + "." + (quarters + startOffset) + "." + (eights + startOffset);
    }
}

