/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.usb;

import java.util.ArrayList;
import java.util.List;

public class USBMatcher {
    private final short vendor;
    private final short productID;
    private final List<EndpointMatcher> endpoints = new ArrayList<EndpointMatcher>();

    public USBMatcher(short vendor, short productID) {
        this.vendor = vendor;
        this.productID = productID;
    }

    public USBMatcher(short vendor, short productID, byte interfaceNumber, byte endpointAddress, boolean isBulk) {
        this(vendor, productID, interfaceNumber, new byte[]{endpointAddress}, new boolean[]{isBulk});
    }

    public USBMatcher(short vendor, short productID, byte interfaceNumber, byte[] endpointAddresses, boolean[] isBulk) {
        this(vendor, productID);
        this.addEndpoints(interfaceNumber, endpointAddresses, isBulk);
    }

    public short getVendor() {
        return this.vendor;
    }

    public short getProductID() {
        return this.productID;
    }

    public final void addEndpoints(byte interfaceNumber, byte[] endpointAddresses, boolean[] isBulk) {
        this.endpoints.add(new EndpointMatcher(interfaceNumber, endpointAddresses, isBulk));
    }

    public final void addEndpoint(byte interfaceNumber, byte endpointAddress, boolean isBulk) {
        this.endpoints.add(new EndpointMatcher(interfaceNumber, new byte[]{endpointAddress}, new boolean[]{isBulk}));
    }

    public List<EndpointMatcher> getEndpoints() {
        return new ArrayList<EndpointMatcher>(this.endpoints);
    }

    public class EndpointMatcher {
        private final byte interfaceNumber;
        private final byte[] endpointAddresses;
        private final boolean[] isBulk;

        public EndpointMatcher(byte interfaceNumber, byte[] endpointAddresses, boolean[] isBulk) {
            this.interfaceNumber = interfaceNumber;
            this.endpointAddresses = endpointAddresses;
            this.isBulk = isBulk;
        }

        public byte getInterfaceNumber() {
            return this.interfaceNumber;
        }

        public byte[] getEndpointAddresses() {
            return this.endpointAddresses;
        }

        public boolean[] getEndpointIsBulk() {
            return this.isBulk;
        }
    }
}

