/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.scale;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.ScaleGrid;
import de.mossgrabers.framework.scale.ScaleLayout;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;

public class Scales {
    private static final String[] NOTE_NAMES = new String[]{"C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B"};
    public static final String[] BASES = new String[]{"C", "G", "D", "A", "E", "B", "F", "Bb", "Eb", "Ab", "Db", "Gb"};
    private static final int[] OFFSETS = new int[]{0, 7, 2, 9, 4, 11, 5, 10, 3, 8, 1, 6};
    public static final int DRUM_NOTE_START = 36;
    public static final int DRUM_NOTE_END = 100;
    private static final int[] DRUM_MATRIX = new int[]{0, 1, 2, 3, -1, -1, -1, -1, 4, 5, 6, 7, -1, -1, -1, -1, 8, 9, 10, 11, -1, -1, -1, -1, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int[] PIANO_MATRIX = new int[]{0, 2, 4, 5, 7, 9, 11, 12, -1, 1, 3, -1, 6, 8, 10, -1, 12, 14, 16, 17, 19, 21, 23, 24, -1, 13, 15, -1, 18, 20, 22, -1, 24, 26, 28, 29, 31, 33, 35, 36, -1, 25, 27, -1, 30, 32, 34, -1, 36, 38, 40, 41, 43, 45, 47, 48, -1, 37, 39, -1, 42, 44, 46, -1};
    public static final String SCALE_COLOR_OFF = "SCALE_COLOR_OFF";
    public static final String SCALE_COLOR_OCTAVE = "SCALE_COLOR_OCTAVE";
    public static final String SCALE_COLOR_NOTE = "SCALE_COLOR_NOTE";
    public static final String SCALE_COLOR_OUT_OF_SCALE = "SCALE_COLOR_OUT_OF_SCALE";
    public static final int OCTAVE_RANGE = 4;
    public static final int PIANO_OCTAVE_RANGE = 3;
    public static final int DRUM_OCTAVE_UPPER = 4;
    public static final int DRUM_OCTAVE_LOWER = -2;
    private Scale selectedScale = Scale.MAJOR;
    private int scaleOffset = 0;
    private ScaleLayout scaleLayout = ScaleLayout.FOURTH_UP;
    private ScaleGrid.Orientation orientation = ScaleGrid.Orientation.ORIENT_UP;
    private boolean chromaticOn = false;
    private int shift = 3;
    private int octave = 0;
    private int drumOctave = 0;
    private int pianoOctave = 0;
    private int startNote;
    private int endNote;
    private int numColumns;
    private int numRows;
    private int[] drumMatrix = DRUM_MATRIX;
    private int drumNoteStart = 36;
    private int drumNoteEnd = 100;
    private final Map<Scale, ScaleGrid> scaleGrids = new EnumMap<Scale, ScaleGrid>(Scale.class);
    private IValueChanger valueChanger;

    public Scales(IValueChanger valueChanger, int startNote, int endNote, int numColumns, int numRows) {
        this.valueChanger = valueChanger;
        this.startNote = startNote;
        this.endNote = endNote;
        this.numColumns = numColumns;
        this.numRows = numRows;
        this.generateMatrices();
    }

    public Scale getScale() {
        return this.selectedScale;
    }

    public void setScale(Scale scale) {
        this.selectedScale = scale;
    }

    public void setScaleByName(String scaleName) {
        this.selectedScale = Scale.getByName(scaleName);
    }

    public void changeScale(int control) {
        Scale[] values = Scale.values();
        int index = this.valueChanger.changeValue(control, this.selectedScale.ordinal(), 1.0, values.length);
        this.selectedScale = values[index];
    }

    public void prevScale() {
        Scale[] values = Scale.values();
        this.selectedScale = values[Math.max(0, this.selectedScale.ordinal() - 1)];
    }

    public void nextScale() {
        Scale[] values = Scale.values();
        this.selectedScale = values[Math.min(values.length - 1, this.selectedScale.ordinal() + 1)];
    }

    public int getScaleOffset() {
        return this.scaleOffset;
    }

    public void setScaleOffset(int scaleOffset) {
        this.scaleOffset = Math.max(0, Math.min(scaleOffset, OFFSETS.length - 1));
    }

    public void changeScaleOffset(int control) {
        this.scaleOffset = this.valueChanger.changeValue(control, this.scaleOffset, 1.0, OFFSETS.length);
    }

    public void setScaleOffsetByName(String scaleOffsetName) {
        for (int i = 0; i < BASES.length; ++i) {
            if (!BASES[i].equals(scaleOffsetName)) continue;
            this.scaleOffset = i;
            break;
        }
    }

    public ScaleLayout getScaleLayout() {
        return this.scaleLayout;
    }

    public void setScaleLayout(ScaleLayout scaleLayout) {
        this.scaleLayout = scaleLayout;
        this.orientation = this.scaleLayout.ordinal() % 2 == 0 ? ScaleGrid.Orientation.ORIENT_UP : ScaleGrid.Orientation.ORIENT_RIGHT;
        switch (this.scaleLayout) {
            case FOURTH_UP: 
            case FOURTH_RIGHT: {
                this.setPlayShift(3);
                break;
            }
            case THIRD_UP: 
            case THIRD_RIGHT: {
                this.setPlayShift(2);
                break;
            }
            case SEQUENT_UP: 
            case SEQUENT_RIGHT: {
                this.setPlayShift(8);
                break;
            }
            case EIGHT_UP: 
            case EIGHT_RIGHT: 
            case EIGHT_UP_CENTER: 
            case EIGHT_RIGHT_CENTER: {
                this.setPlayShift(7);
            }
        }
    }

    public void setScaleLayoutByName(String scaleLayoutName) {
        this.setScaleLayout(ScaleLayout.getByName(scaleLayoutName));
    }

    public void prevScaleLayout() {
        ScaleLayout[] values = ScaleLayout.values();
        this.scaleLayout = values[Math.max(0, this.scaleLayout.ordinal() - 1)];
    }

    public void nextScaleLayout() {
        ScaleLayout[] values = ScaleLayout.values();
        this.scaleLayout = values[Math.min(values.length - 1, this.scaleLayout.ordinal() + 1)];
    }

    public void setChromatic(boolean enable) {
        this.chromaticOn = enable;
    }

    public void toggleChromatic() {
        this.chromaticOn = !this.chromaticOn;
    }

    public boolean isChromatic() {
        return this.chromaticOn;
    }

    public void setOctave(int octave) {
        this.octave = Math.max(-4, Math.min(octave, 4));
    }

    public int getOctave() {
        return this.octave;
    }

    public void incOctave() {
        this.setOctave(this.octave + 1);
    }

    public void decOctave() {
        this.setOctave(this.octave - 1);
    }

    public void setDrumOctave(int drumOctave) {
        this.drumOctave = Math.max(-2, Math.min(drumOctave, 4));
    }

    public int getDrumOctave() {
        return this.drumOctave;
    }

    public void incDrumOctave() {
        this.setDrumOctave(this.drumOctave + 1);
    }

    public void decDrumOctave() {
        this.setDrumOctave(this.drumOctave - 1);
    }

    public void setPianoOctave(int octave) {
        this.pianoOctave = Math.max(-3, Math.min(octave, 3));
    }

    public int getPianoOctave() {
        return this.pianoOctave;
    }

    public void incPianoOctave() {
        this.setPianoOctave(this.pianoOctave + 1);
    }

    public void decPianoOctave() {
        this.setPianoOctave(this.pianoOctave - 1);
    }

    public void setPlayShift(int shift) {
        this.shift = shift;
        this.generateMatrices();
    }

    public int getPlayShift() {
        return this.shift;
    }

    public String getColor(int[] noteMap, int note) {
        int midiNote = noteMap[note];
        if (midiNote == -1) {
            return SCALE_COLOR_OFF;
        }
        int n = (midiNote - OFFSETS[this.scaleOffset]) % 12;
        if (n == 0) {
            return SCALE_COLOR_OCTAVE;
        }
        if (this.isChromatic()) {
            int[] notes;
            for (int note2 : notes = this.selectedScale.getIntervals()) {
                if (note2 != n) continue;
                return SCALE_COLOR_NOTE;
            }
            return SCALE_COLOR_OUT_OF_SCALE;
        }
        return SCALE_COLOR_NOTE;
    }

    public int[] getNoteMatrix() {
        int[] matrix = this.getActiveMatrix();
        int[] noteMap = Scales.getEmptyMatrix();
        for (int note = this.startNote; note < this.endNote; ++note) {
            int n = matrix[note - this.startNote] + OFFSETS[this.scaleOffset] + this.startNote + this.octave * 12;
            noteMap[note] = n < 0 || n > 127 ? -1 : n;
        }
        return noteMap;
    }

    public int[] getSequencerMatrix(int length, int offset) {
        int[] matrix = this.getActiveMatrix();
        int[] noteMap = new int[length];
        Arrays.fill(noteMap, -1);
        for (int note = 0; note < length; ++note) {
            int n = matrix[note] + OFFSETS[this.scaleOffset] + offset;
            noteMap[note] = n < 0 || n > 127 ? -1 : n;
        }
        return noteMap;
    }

    public int[] getPianoMatrix() {
        int[] matrix = PIANO_MATRIX;
        int[] noteMap = Scales.getEmptyMatrix();
        for (int note = this.startNote; note < this.endNote; ++note) {
            int n = matrix[note - this.startNote] == -1 ? -1 : matrix[note - this.startNote] + this.startNote + this.pianoOctave * 12;
            noteMap[note] = n < 0 || n > 127 ? -1 : n;
        }
        return noteMap;
    }

    public static int[] getEmptyMatrix() {
        int[] emptyMatrix = new int[128];
        Arrays.fill(emptyMatrix, -1);
        return emptyMatrix;
    }

    public static int[] getIdentityMatrix() {
        int[] identityMatrix = new int[128];
        for (int i = 0; i < 128; ++i) {
            identityMatrix[i] = i;
        }
        return identityMatrix;
    }

    public int[] getDrumMatrix() {
        int[] noteMap = Scales.getEmptyMatrix();
        for (int note = this.drumNoteStart; note < this.drumNoteEnd; ++note) {
            int n = this.drumMatrix[note - this.drumNoteStart] == -1 ? -1 : this.drumMatrix[note - this.drumNoteStart] + this.drumNoteStart + this.drumOctave * 16;
            noteMap[note] = n < 0 || n > 127 ? -1 : n;
        }
        return noteMap;
    }

    public void setDrumMatrix(int[] matrix) {
        this.drumMatrix = matrix;
    }

    public void setDrumNoteStart(int drumNoteStart) {
        this.drumNoteStart = drumNoteStart;
    }

    public void setDrumNoteEnd(int drumNoteEnd) {
        this.drumNoteEnd = drumNoteEnd;
    }

    public String getRangeText() {
        int[] matrix = this.getActiveMatrix();
        int offset = OFFSETS[this.scaleOffset];
        return this.formatNote(offset + matrix[0]) + " to " + this.formatNote(offset + matrix[matrix.length - 1]);
    }

    public static String getSequencerRangeText(int from, int to) {
        return Scales.formatNoteAndOctave(from, -3) + " to " + Scales.formatNoteAndOctave(to, -3);
    }

    public String getDrumRangeText() {
        int s = this.startNote + this.drumOctave * 16;
        return Scales.formatDrumNote(s) + " to " + Scales.formatDrumNote(s + 15);
    }

    public String getPianoRangeText() {
        return this.formatNote(this.pianoOctave * 12) + " to " + this.formatNote((this.pianoOctave + 4) * 12);
    }

    public String formatNote(int note) {
        return Scales.formatNoteAndOctave(note, this.octave);
    }

    public static String formatDrumNote(int note) {
        return Scales.formatNoteAndOctave(note, -3);
    }

    public static String formatNoteAndOctave(int note, int octaveOffset) {
        return NOTE_NAMES[Math.abs(note % 12)] + Integer.toString(note / 12 + octaveOffset + 1);
    }

    public int[] getActiveMatrix() {
        ScaleGrid scaleGrid = this.scaleGrids.get((Object)this.selectedScale);
        return this.isChromatic() ? scaleGrid.getChromatic() : scaleGrid.getMatrix();
    }

    public int[] translateMatrixToGrid(int[] matrix) {
        return matrix;
    }

    private void generateMatrices() {
        this.scaleGrids.clear();
        for (Scale scale : Scale.values()) {
            this.scaleGrids.put(scale, new ScaleGrid(scale, this.scaleLayout, this.orientation, this.numRows, this.numColumns, this.shift));
        }
    }

    public int getStartNote() {
        return this.startNote;
    }

    public void setStartNote(int startNote) {
        this.startNote = startNote;
    }

    public int getEndNote() {
        return this.endNote;
    }

    public void setEndNote(int endNote) {
        this.endNote = endNote;
    }
}

