/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.scale;

import java.util.HashSet;
import java.util.Set;

public enum Scale {
    MAJOR("Major", new int[]{0, 2, 4, 5, 7, 9, 11}),
    MINOR("Minor", new int[]{0, 2, 3, 5, 7, 8, 10}),
    DORIAN("Dorian", new int[]{0, 2, 3, 5, 7, 9, 10}),
    MIXOLYDIAN("Mixolydian", new int[]{0, 2, 4, 5, 7, 9, 10}),
    LYDIAN("Lydian", new int[]{0, 2, 4, 6, 7, 9, 11}),
    PHRYGIAN("Phrygian", new int[]{0, 1, 3, 5, 7, 8, 10}),
    LOCRIAN("Locrian", new int[]{0, 1, 3, 5, 6, 8, 10}),
    DIMINISHED("Diminished", new int[]{0, 1, 3, 4, 6, 7, 9, 10}),
    WHOLE_HALF("Whole-half", new int[]{0, 2, 3, 5, 6, 8, 9, 11}),
    HALF_WHOLE("Half-whole", new int[]{0, 1, 3, 4, 6, 7, 9, 10}),
    WHOLE_TONE("Whole Tone", new int[]{0, 2, 4, 6, 8, 10}),
    MINOR_BLUES("Minor Blues", new int[]{0, 3, 5, 6, 7, 10}),
    MINOR_PENTATONIC("Minor Pentatonic", new int[]{0, 3, 5, 7, 10}),
    MAJOR_PENTATONIC("Major Pentatonic", new int[]{0, 2, 4, 7, 9}),
    HARMONIC_MINOR("Harmonic Minor", new int[]{0, 2, 3, 5, 7, 8, 11}),
    MELODIC_MINOR("Melodic Minor", new int[]{0, 2, 3, 5, 7, 9, 11}),
    SUPER_LOCRIAN("Super Locrian", new int[]{0, 1, 3, 4, 6, 8, 10}),
    BHAIRAV("Bhairav", new int[]{0, 1, 4, 5, 7, 8, 11}),
    HUNGARIAN_MINOR("Hungarian Minor", new int[]{0, 2, 3, 6, 7, 8, 11}),
    MINOR_GYPSI("Minor Gypsy", new int[]{0, 1, 4, 5, 7, 8, 10}),
    HIROJOSHI("Hirojoshi", new int[]{0, 2, 3, 7, 8}),
    IN_SEN("In-Sen", new int[]{0, 1, 5, 7, 10}),
    IWATO("Iwato", new int[]{0, 1, 5, 6, 10}),
    KUMOI("Kumoi", new int[]{0, 2, 3, 7, 9}),
    PELOG("Pelog", new int[]{0, 1, 3, 4, 7, 8}),
    SPANISH("Spanish", new int[]{0, 1, 4, 5, 7, 9, 10});

    private String name;
    private int[] intervals;
    private Set<Integer> scaleKeys = new HashSet<Integer>(7);

    private Scale(String name, int[] intervals) {
        this.name = name;
        for (int interval : this.intervals = intervals) {
            this.scaleKeys.add(interval);
        }
    }

    public String getName() {
        return this.name;
    }

    public int[] getIntervals() {
        return this.intervals;
    }

    public boolean isInScale(int note) {
        return this.scaleKeys.contains(note);
    }

    public static String[] getNames() {
        Scale[] values = Scale.values();
        String[] scaleNames = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            scaleNames[i] = values[i].name;
        }
        return scaleNames;
    }

    public static Scale getByName(String name) {
        for (Scale scale : Scale.values()) {
            if (!scale.getName().equals(name)) continue;
            return scale;
        }
        return null;
    }
}

