/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.osc;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.osc.IOpenSoundControlConfiguration;
import de.mossgrabers.framework.osc.IOpenSoundControlMessage;
import de.mossgrabers.framework.osc.IOpenSoundControlServer;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractOpenSoundControlWriter
implements IOpenSoundControlWriter {
    protected final IHost host;
    protected final IModel model;
    protected final IOpenSoundControlConfiguration configuration;
    protected final IOpenSoundControlServer oscServer;
    protected final Map<String, Object> oldValues = new HashMap<String, Object>();
    private final List<IOpenSoundControlMessage> messages = new ArrayList<IOpenSoundControlMessage>();

    protected AbstractOpenSoundControlWriter(IHost host, IModel model, IOpenSoundControlServer oscServer, IOpenSoundControlConfiguration configuration) {
        this.host = host;
        this.model = model;
        this.oscServer = oscServer;
        this.configuration = configuration;
    }

    public void flush() {
        try {
            this.logMessages(this.messages);
            this.oscServer.sendBundle(this.messages);
        }
        catch (IOException ex) {
            this.model.getHost().error("Could not send UDP message.", ex);
        }
        this.messages.clear();
    }

    @Override
    public void fastSendOSC(String address, int[] numbers) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (int number : numbers) {
            params.add(number);
        }
        this.fastSendOSC(address, params);
    }

    @Override
    public void fastSendOSC(String address) {
        this.fastSendOSC(address, Collections.emptyList());
    }

    protected void fastSendOSC(String address, List<Object> parameters) {
        this.sendOSC(address, parameters, true);
        this.flush();
    }

    protected void sendOSCColor(String address, double red, double green, double blue, boolean dump) {
        int r = (int)Math.round(red * 255.0);
        int g = (int)Math.round(green * 255.0);
        int b = (int)Math.round(blue * 255.0);
        this.sendOSC(address, "rgb(" + r + "," + g + "," + b + ")", dump);
    }

    protected void sendOSC(String address, boolean value, boolean dump) {
        this.sendOSC(address, (Object)value, dump);
    }

    protected void sendOSC(String address, double value, boolean dump) {
        this.sendOSC(address, Float.valueOf((float)value), dump);
    }

    protected void sendOSC(String address, int value, boolean dump) {
        this.sendOSC(address, (Object)value, dump);
    }

    protected void sendOSC(String address, String value, boolean dump) {
        this.sendOSC(address, (Object)StringUtils.fixASCII(value), dump);
    }

    protected void sendOSC(String address, Object value, boolean dump) {
        this.sendOSC(address, address, value, value, dump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendOSC(String cacheAddress, String address, Object testValue, Object value, boolean dump) {
        if (!dump && AbstractOpenSoundControlWriter.compareValues(this.oldValues.get(cacheAddress), testValue)) {
            return;
        }
        this.oldValues.put(cacheAddress, testValue);
        List<IOpenSoundControlMessage> list = this.messages;
        synchronized (list) {
            Object converted = AbstractOpenSoundControlWriter.convertBooleanToInt(value);
            this.messages.add(this.host.createOSCMessage(address, converted instanceof List ? (List<Object>)converted : Collections.singletonList(converted)));
        }
    }

    protected boolean isConnected() {
        return this.oscServer != null;
    }

    protected static List<Object> convertToList(Object value) {
        if (value instanceof List) {
            return (List)List.class.cast(value);
        }
        if (value instanceof Boolean) {
            return Collections.singletonList((Boolean)value != false ? 1 : 0);
        }
        return Collections.singletonList(value);
    }

    protected static boolean compareValues(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value1 instanceof List && value2 instanceof List) {
            int size2;
            List l1 = (List)List.class.cast(value1);
            List l2 = (List)List.class.cast(value2);
            int size1 = l1.size();
            if (size1 != (size2 = l2.size())) {
                return false;
            }
            for (int i = 0; i < size1; ++i) {
                if (l1.get(i).equals(l2.get(i))) continue;
                return false;
            }
            return true;
        }
        return value1.equals(value2);
    }

    private static Object convertBooleanToInt(Object value) {
        return value instanceof Boolean ? Integer.valueOf((Boolean)value != false ? 1 : 0) : value;
    }

    protected void logMessages(List<IOpenSoundControlMessage> messages) {
        if (!this.configuration.shouldLogOutputCommands() || messages.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (IOpenSoundControlMessage message : messages) {
            String address = message.getAddress();
            if (this.configuration.filterHeartbeatMessages() && this.isHeartbeatMessage(address)) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append("Sending: ").append(address).append(" [ ");
            Object[] values = message.getValues();
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(values[i]);
            }
            sb.append(" ]");
        }
        if (sb.length() > 0) {
            this.model.getHost().println(sb.toString());
        }
    }

    protected boolean isHeartbeatMessage(String address) {
        return false;
    }
}

