/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.osc;

import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.osc.IOpenSoundControlCallback;
import de.mossgrabers.framework.osc.IOpenSoundControlConfiguration;
import de.mossgrabers.framework.osc.IOpenSoundControlMessage;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.scale.Scales;

public abstract class AbstractOpenSoundControlParser
implements IOpenSoundControlCallback {
    protected final IHost host;
    protected final IModel model;
    protected final ITransport transport;
    protected final IMasterTrack masterTrack;
    protected final ICursorClip clip;
    protected final Scales scales;
    protected final IMidiInput midiInput;
    protected final IOpenSoundControlConfiguration configuration;
    protected final IOpenSoundControlWriter writer;

    protected AbstractOpenSoundControlParser(IHost host, IModel model, IMidiInput midiInput, IOpenSoundControlConfiguration configuration, IOpenSoundControlWriter writer) {
        this.host = host;
        this.model = model;
        this.transport = model.getTransport();
        this.masterTrack = model.getMasterTrack();
        this.scales = model.getScales();
        this.clip = model.getCursorClip(8, 8);
        this.midiInput = midiInput;
        this.configuration = configuration;
        this.writer = writer;
    }

    protected void logMessage(IOpenSoundControlMessage message) {
        if (!this.configuration.shouldLogInputCommands()) {
            return;
        }
        String address = message.getAddress();
        if (this.configuration.filterHeartbeatMessages() && this.isHeartbeatMessage(address)) {
            return;
        }
        StringBuilder sb = new StringBuilder("Receiving: ").append(address).append(" [ ");
        Object[] values = message.getValues();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(values[i]);
        }
        sb.append(" ]");
        this.model.getHost().println(sb.toString());
    }

    protected boolean isHeartbeatMessage(String address) {
        return false;
    }
}

