/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode;

import de.mossgrabers.framework.mode.Mode;
import de.mossgrabers.framework.mode.ModeChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModeManager {
    private final Map<Integer, Mode> modes = new HashMap<Integer, Mode>();
    private final List<ModeChangeListener> modeChangeListeners = new ArrayList<ModeChangeListener>();
    private Integer activeModeId = null;
    private Integer previousModeId = null;
    private Integer temporaryModeId = null;
    private Integer defaultModeId = null;

    public void registerMode(Integer modeId, Mode mode) {
        this.modes.put(modeId, mode);
    }

    public Mode getMode(Integer modeId) {
        return this.modes.get(modeId);
    }

    public void setActiveMode(Integer modeId) {
        Integer id;
        Integer n = id = modeId == null ? this.defaultModeId : modeId;
        if (this.isActiveMode(id)) {
            return;
        }
        if (this.temporaryModeId != null) {
            this.getMode(this.temporaryModeId).onDeactivate();
            this.temporaryModeId = null;
        } else if (this.activeModeId != null) {
            this.getMode(this.activeModeId).onDeactivate();
        }
        if (id == null) {
            this.previousModeId = this.activeModeId;
            this.activeModeId = null;
        } else {
            Mode newMode = this.getMode(id);
            if (newMode.isTemporary()) {
                this.temporaryModeId = id;
            } else {
                this.previousModeId = this.activeModeId;
                this.activeModeId = id;
            }
            newMode.onActivate();
        }
        this.notifyObservers(this.previousModeId, this.getActiveModeId());
    }

    public Mode getActiveMode() {
        return this.modes.get(this.getActiveModeId());
    }

    public Integer getActiveModeId() {
        return this.temporaryModeId == null ? this.activeModeId : this.temporaryModeId;
    }

    public boolean isActiveMode(Integer modeId) {
        Integer mode = this.getActiveModeId();
        return mode != null && mode.equals(modeId);
    }

    public Integer getPreviousModeId() {
        return this.previousModeId;
    }

    public void restoreMode() {
        Integer oldModeId = null;
        if (this.temporaryModeId != null) {
            oldModeId = this.temporaryModeId;
            this.getMode(this.temporaryModeId).onDeactivate();
            this.temporaryModeId = null;
            Mode mode = this.getMode(this.activeModeId);
            if (mode == null) {
                this.activeModeId = this.defaultModeId;
                mode = this.getMode(this.activeModeId);
            }
            mode.onActivate();
        } else if (this.previousModeId != null) {
            oldModeId = this.activeModeId;
            this.getMode(this.activeModeId).onDeactivate();
            this.activeModeId = this.previousModeId;
            Mode mode = this.getMode(this.activeModeId);
            if (mode == null) {
                this.activeModeId = this.defaultModeId;
                mode = this.getMode(this.activeModeId);
            }
            mode.onActivate();
        }
        if (oldModeId != null) {
            this.notifyObservers(oldModeId, this.activeModeId);
        }
    }

    public void setDefaultMode(Integer modeId) {
        this.defaultModeId = modeId;
    }

    public void addModeListener(ModeChangeListener listener) {
        this.modeChangeListeners.add(listener);
    }

    private void notifyObservers(Integer oldMode, Integer newMode) {
        for (ModeChangeListener listener : this.modeChangeListeners) {
            listener.call(oldMode, newMode);
        }
    }
}

