/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw;

public class DAWColors {
    private static final Object[] COLORS = new Object[]{new double[]{0.5, 0.5, 0.5}, new double[]{0.3294117748737335, 0.3294117748737335, 0.3294117748737335}, new double[]{0.47843137383461, 0.47843137383461, 0.47843137383461}, new double[]{0.7882353067398071, 0.7882353067398071, 0.7882353067398071}, new double[]{0.5254902243614197, 0.5372549295425415, 0.6745098233222961}, new double[]{0.6392157077789307, 0.4745098054409027, 0.2627451f}, new double[]{0.7764706015586853, 0.6235294342041016, 0.4392157f}, new double[]{0.34117648005485535, 0.3803921639919281, 0.7764706015586853}, new double[]{0.5176470875740051, 0.5411764979362488, 0.8784313797950745}, new double[]{0.5843137502670288, 0.2862745225429535, 0.7960784435272217}, new double[]{0.8509804010391235, 0.21960784494876862, 0.4431372582912445}, new double[]{0.8509804010391235, 0.18039216101169586, 0.1411764770746231}, new double[]{1.0, 0.34117648005485535, 0.0235294122248888}, new double[]{0.8509804010391235, 0.615686297416687, 0.062745101749897}, new double[]{0.4509804f, 0.5960784554481506, 0.0784313753247261}, new double[]{0.0, 0.615686297416687, 0.2784314f}, new double[]{0.0, 0.6509804129600525, 0.5803921818733215}, new double[]{0.0, 0.6f, 0.8509804010391235}, new double[]{0.7372549176216125, 0.4627451002597809, 0.9411764740943909}, new double[]{0.8823529481887817, 0.4f, 0.5686274766921997}, new double[]{0.9254902005195618, 0.3803921639919281, 0.34117648005485535}, new double[]{1.0, 0.5137255191802979, 0.24313725531101227}, new double[]{0.8941176533699036, 0.7176470756530762, 0.30588236451148987}, new double[]{0.627451f, 0.7529411911964417, 0.2980392277240753}, new double[]{0.24313725531101227, 0.7333333492279053, 0.3843137323856354}, new double[]{0.2627451f, 0.8235294222831726, 0.7254902124404907}, new double[]{0.2666666805744171, 0.7843137383460999, 1.0}};
    public static final String COLOR_OFF = "COLOR_OFF";
    public static final String DAW_COLOR_DARK_GRAY = "DAW_COLOR_DARK_GRAY";
    public static final String DAW_COLOR_GRAY = "DAW_COLOR_GRAY";
    public static final String DAW_COLOR_LIGHT_GRAY = "DAW_COLOR_LIGHT_GRAY";
    public static final String DAW_COLOR_SILVER = "DAW_COLOR_SILVER";
    public static final String DAW_COLOR_DARK_BROWN = "DAW_COLOR_DARK_BROWN";
    public static final String DAW_COLOR_BROWN = "DAW_COLOR_BROWN";
    public static final String DAW_COLOR_DARK_BLUE = "DAW_COLOR_DARK_BLUE";
    public static final String DAW_COLOR_PURPLE_BLUE = "DAW_COLOR_PURPLE_BLUE";
    public static final String DAW_COLOR_PURPLE = "DAW_COLOR_PURPLE";
    public static final String DAW_COLOR_PINK = "DAW_COLOR_PINK";
    public static final String DAW_COLOR_RED = "DAW_COLOR_RED";
    public static final String DAW_COLOR_ORANGE = "DAW_COLOR_ORANGE";
    public static final String DAW_COLOR_LIGHT_ORANGE = "DAW_COLOR_LIGHT_ORANGE";
    public static final String DAW_COLOR_MOSS_GREEN = "DAW_COLOR_MOSS_GREEN";
    public static final String DAW_COLOR_GREEN = "DAW_COLOR_GREEN";
    public static final String DAW_COLOR_COLD_GREEN = "DAW_COLOR_COLD_GREEN";
    public static final String DAW_COLOR_BLUE = "DAW_COLOR_BLUE";
    public static final String DAW_COLOR_LIGHT_PURPLE = "DAW_COLOR_LIGHT_PURPLE";
    public static final String DAW_COLOR_LIGHT_PINK = "DAW_COLOR_LIGHT_PINK";
    public static final String DAW_COLOR_SKIN = "DAW_COLOR_SKIN";
    public static final String DAW_COLOR_REDDISH_BROWN = "DAW_COLOR_REDDISH_BROWN";
    public static final String DAW_COLOR_LIGHT_BROWN = "DAW_COLOR_LIGHT_BROWN";
    public static final String DAW_COLOR_LIGHT_GREEN = "DAW_COLOR_LIGHT_GREEN";
    public static final String DAW_COLOR_BLUISH_GREEN = "DAW_COLOR_BLUISH_GREEN";
    public static final String DAW_COLOR_GREEN_BLUE = "DAW_COLOR_GREEN_BLUE";
    public static final String DAW_COLOR_LIGHT_BLUE = "DAW_COLOR_LIGHT_BLUE";
    public static final String[] DAW_COLORS = new String[]{"DAW_COLOR_GRAY", "DAW_COLOR_DARK_GRAY", "DAW_COLOR_GRAY", "DAW_COLOR_LIGHT_GRAY", "DAW_COLOR_SILVER", "DAW_COLOR_DARK_BROWN", "DAW_COLOR_BROWN", "DAW_COLOR_DARK_BLUE", "DAW_COLOR_PURPLE_BLUE", "DAW_COLOR_PURPLE", "DAW_COLOR_PINK", "DAW_COLOR_RED", "DAW_COLOR_ORANGE", "DAW_COLOR_LIGHT_ORANGE", "DAW_COLOR_MOSS_GREEN", "DAW_COLOR_GREEN", "DAW_COLOR_COLD_GREEN", "DAW_COLOR_BLUE", "DAW_COLOR_LIGHT_PURPLE", "DAW_COLOR_LIGHT_PINK", "DAW_COLOR_SKIN", "DAW_COLOR_REDDISH_BROWN", "DAW_COLOR_LIGHT_BROWN", "DAW_COLOR_LIGHT_GREEN", "DAW_COLOR_BLUISH_GREEN", "DAW_COLOR_GREEN_BLUE", "DAW_COLOR_LIGHT_BLUE"};

    private DAWColors() {
    }

    public static double[] getColorEntry(String colorId) {
        for (int i = 0; i < DAW_COLORS.length; ++i) {
            if (DAW_COLORS[i] != colorId) continue;
            return (double[])COLORS[i];
        }
        return (double[])COLORS[0];
    }

    public static String getColorIndex(double[] rgb) {
        return DAWColors.getColorIndex(rgb[0], rgb[1], rgb[2]);
    }

    public static String getColorIndex(double red, double green, double blue) {
        String cid = COLOR_OFF;
        double minError = 1.0;
        for (int i = 0; i < COLORS.length; ++i) {
            double[] color = (double[])COLORS[i];
            double error = Math.pow(color[0] - red, 2.0) + Math.pow(color[1] - green, 2.0) + Math.pow(color[2] - blue, 2.0);
            if (!(error < minError)) continue;
            cid = DAW_COLORS[i];
            minError = error;
        }
        return cid;
    }
}

