/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IArranger;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMixer;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.ISceneBank;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.scale.Scales;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractModel
implements IModel {
    protected IHost host;
    protected IApplication application;
    protected IArranger arranger;
    protected IMixer mixer;
    protected ITransport transport;
    protected IGroove groove;
    protected IProject project;
    protected IBrowser browser;
    protected IChannelBank currentTrackBank;
    protected ITrackBank trackBank;
    protected IChannelBank effectTrackBank;
    protected IMasterTrack masterTrack;
    protected ICursorDevice primaryDevice;
    protected ICursorDevice cursorDevice;
    protected ICursorDevice drumDevice64;
    protected Map<String, ICursorClip> cursorClips = new HashMap<String, ICursorClip>();
    protected Scales scales;
    protected ColorManager colorManager;
    protected IValueChanger valueChanger;
    protected int numTracks;
    protected int numScenes;
    protected int numSends;
    protected int numFilterColumnEntries;
    protected int numResults;
    protected int numParams;
    protected int numDevicesInBank;
    protected int numDeviceLayers;
    protected int numDrumPadLayers;
    protected boolean hasFlatTrackList;

    public AbstractModel(ColorManager colorManager, IValueChanger valueChanger, Scales scales, int numTracks, int numScenes, int numSends, int numFilterColumnEntries, int numResults, boolean hasFlatTrackList, int numParams, int numDevicesInBank, int numDeviceLayers, int numDrumPadLayers) {
        this.colorManager = colorManager;
        this.valueChanger = valueChanger;
        this.scales = scales;
        this.numTracks = numTracks < 0 ? 8 : numTracks;
        this.numScenes = numScenes < 0 ? 8 : numScenes;
        this.numSends = numSends < 0 ? 6 : numSends;
        this.numFilterColumnEntries = numFilterColumnEntries < 0 ? 16 : numFilterColumnEntries;
        this.numResults = numResults < 0 ? 16 : numResults;
        this.numParams = numParams >= 0 ? numParams : 8;
        this.numDevicesInBank = numDevicesInBank >= 0 ? numDevicesInBank : 8;
        this.numDeviceLayers = numDeviceLayers >= 0 ? numDeviceLayers : 8;
        this.numDrumPadLayers = numDrumPadLayers >= 0 ? numDrumPadLayers : 16;
        this.hasFlatTrackList = hasFlatTrackList;
    }

    @Override
    public IHost getHost() {
        return this.host;
    }

    @Override
    public IValueChanger getValueChanger() {
        return this.valueChanger;
    }

    @Override
    public IArranger getArranger() {
        return this.arranger;
    }

    @Override
    public IMixer getMixer() {
        return this.mixer;
    }

    @Override
    public ColorManager getColorManager() {
        return this.colorManager;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public ITransport getTransport() {
        return this.transport;
    }

    @Override
    public IGroove getGroove() {
        return this.groove;
    }

    @Override
    public IMasterTrack getMasterTrack() {
        return this.masterTrack;
    }

    @Override
    public Scales getScales() {
        return this.scales;
    }

    @Override
    public ICursorDevice getCursorDevice() {
        return this.cursorDevice;
    }

    @Override
    public ICursorDevice getPrimaryDevice() {
        return this.primaryDevice;
    }

    @Override
    public ICursorDevice getDrumDevice64() {
        return this.drumDevice64;
    }

    @Override
    public ICursorClip getCursorClip() {
        return this.getCursorClip(this.numTracks, this.numScenes);
    }

    @Override
    public void toggleCurrentTrackBank() {
        this.currentTrackBank = this.currentTrackBank == this.trackBank && this.effectTrackBank != null ? this.effectTrackBank : this.trackBank;
    }

    @Override
    public boolean isEffectTrackBankActive() {
        return this.currentTrackBank == this.effectTrackBank;
    }

    @Override
    public IChannelBank getCurrentTrackBank() {
        return this.currentTrackBank;
    }

    @Override
    public ITrackBank getTrackBank() {
        return this.trackBank;
    }

    @Override
    public IChannelBank getEffectTrackBank() {
        return this.effectTrackBank;
    }

    @Override
    public IApplication getApplication() {
        return this.application;
    }

    @Override
    public IBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public boolean hasSelectedDevice() {
        return this.cursorDevice.doesExist();
    }

    @Override
    public ISceneBank getSceneBank() {
        return this.trackBank.getSceneBank();
    }

    @Override
    public void createClip(ISlot slot, int clipLength) {
        slot.create((int)(clipLength < 2 ? Math.pow(2.0, clipLength) : Math.pow(2.0, (double)clipLength - 2.0) * (double)this.transport.getQuartersPerMeasure()));
    }

    @Override
    public boolean hasRecordingState() {
        return this.transport.isRecording() || this.transport.isLauncherOverdub() || this.currentTrackBank.isClipRecording();
    }

    @Override
    public boolean canSelectedTrackHoldNotes() {
        ITrack t = this.getCurrentTrackBank().getSelectedTrack();
        return t != null && t.canHoldNotes();
    }

    @Override
    public ITrack getSelectedTrack() {
        IChannelBank tb = this.getCurrentTrackBank();
        return tb == null ? null : tb.getSelectedTrack();
    }

    @Override
    public ISlot getSelectedSlot() {
        ITrack track = this.getSelectedTrack();
        return track == null ? null : track.getSelectedSlot();
    }

    @Override
    public boolean canConvertClip() {
        ITrack selectedTrack = this.getSelectedTrack();
        if (selectedTrack == null) {
            return false;
        }
        ISlot[] slots = selectedTrack.getSelectedSlots();
        if (slots.length == 0) {
            return false;
        }
        for (ISlot slot : slots) {
            if (!slot.hasContent()) continue;
            return true;
        }
        return false;
    }
}

