/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw;

import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ISceneBank;
import de.mossgrabers.framework.daw.NoteObserver;
import de.mossgrabers.framework.daw.TrackSelectionObserver;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractChannelBank
implements IChannelBank {
    protected static final int NOTE_OFF = 0;
    protected static final int NOTE_ON = 1;
    protected static final int NOTE_ON_NEW = 2;
    protected int numTracks;
    protected int numScenes;
    protected int numSends;
    protected ITrack[] tracks;
    protected ISceneBank sceneBank;
    protected final IValueChanger valueChanger;
    protected final Set<NoteObserver> noteObservers = new HashSet<NoteObserver>();
    protected final Set<TrackSelectionObserver> observers = new HashSet<TrackSelectionObserver>();
    protected final int[][] noteCache;

    public AbstractChannelBank(IValueChanger valueChanger, int numTracks, int numScenes, int numSends) {
        this.valueChanger = valueChanger;
        this.numTracks = numTracks;
        this.numScenes = numScenes;
        this.numSends = numSends;
        this.noteCache = new int[numTracks][];
        for (int i = 0; i < numTracks; ++i) {
            this.noteCache[i] = new int[128];
            Arrays.fill(this.noteCache[i], 0);
        }
    }

    @Override
    public void addTrackSelectionObserver(TrackSelectionObserver observer) {
        this.observers.add(observer);
    }

    protected void notifyTrackSelectionObservers(int trackIndex, boolean isSelected) {
        for (TrackSelectionObserver observer : this.observers) {
            observer.call(trackIndex, isSelected);
        }
    }

    @Override
    public boolean isClipRecording() {
        for (int t = 0; t < this.numTracks; ++t) {
            for (int s = 0; s < this.numScenes; ++s) {
                if (!this.tracks[t].getSlot(s).isRecording()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ITrack getTrack(int index) {
        return this.tracks[index];
    }

    @Override
    public ITrack getSelectedTrack() {
        for (int i = 0; i < this.numTracks; ++i) {
            if (!this.tracks[i].isSelected()) continue;
            return this.tracks[i];
        }
        return null;
    }

    @Override
    public String getSelectedTrackColorEntry() {
        ITrack selectedTrack = this.getSelectedTrack();
        if (selectedTrack == null) {
            return "COLOR_OFF";
        }
        double[] color = selectedTrack.getColor();
        return DAWColors.getColorIndex(color[0], color[1], color[2]);
    }

    @Override
    public String getColorOfFirstClipInScene(int scene) {
        for (int t = 0; t < this.getNumTracks(); ++t) {
            ISlot slot = this.getTrack(t).getSlot(scene);
            if (!slot.doesExist() || !slot.hasContent()) continue;
            return DAWColors.getColorIndex(slot.getColor());
        }
        return "DAW_COLOR_GREEN";
    }

    @Override
    public void stop() {
        if (this.sceneBank != null) {
            this.sceneBank.stop();
        }
    }

    @Override
    public ISceneBank getSceneBank() {
        return this.sceneBank;
    }

    @Override
    public void launchScene(int scene) {
        if (this.sceneBank != null) {
            this.sceneBank.launchScene(scene);
        }
    }

    @Override
    public boolean canScrollScenesUp() {
        return this.sceneBank != null ? this.sceneBank.canScrollScenesUp() : false;
    }

    @Override
    public boolean canScrollScenesDown() {
        return this.sceneBank != null ? this.sceneBank.canScrollScenesDown() : false;
    }

    @Override
    public void scrollScenesUp() {
        if (this.sceneBank != null) {
            this.sceneBank.scrollScenesUp();
        }
    }

    @Override
    public void scrollScenesDown() {
        if (this.sceneBank != null) {
            this.sceneBank.scrollScenesDown();
        }
    }

    @Override
    public void scrollScenesPageUp() {
        if (this.sceneBank != null) {
            this.sceneBank.scrollScenesPageUp();
        }
    }

    @Override
    public void scrollScenesPageDown() {
        if (this.sceneBank != null) {
            this.sceneBank.scrollScenesPageDown();
        }
    }

    @Override
    public int getScenePosition() {
        return this.sceneBank == null ? -1 : this.sceneBank.getScrollPosition();
    }

    @Override
    public void addNoteObserver(NoteObserver observer) {
        this.noteObservers.add(observer);
    }

    protected void notifyNoteObservers(int note, int velocity) {
        for (NoteObserver noteObserver : this.noteObservers) {
            noteObserver.call(note, velocity);
        }
    }

    @Override
    public int getNumTracks() {
        return this.numTracks;
    }

    @Override
    public int getNumScenes() {
        return this.numScenes;
    }

    @Override
    public int getNumSends() {
        return this.numSends;
    }
}

