/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw;

import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;

public abstract class AbstractBrowser
implements IBrowser {
    protected final int numResults;
    protected final int numFilterColumnEntries;
    protected final ICursorDevice cursorDevice;
    protected IBrowserColumnItem[] resultData;
    protected IBrowserColumn[] columnData;

    public AbstractBrowser(ICursorDevice cursorDevice, int numFilterColumnEntries, int numResults) {
        this.cursorDevice = cursorDevice;
        this.numFilterColumnEntries = numFilterColumnEntries;
        this.numResults = numResults;
    }

    @Override
    public boolean hasPreviousContentType() {
        return this.getSelectedContentTypeIndex() > 0;
    }

    @Override
    public boolean hasNextContentType() {
        return this.getSelectedContentTypeIndex() > this.getContentTypeNames().length - 1;
    }

    @Override
    public void resetFilterColumn(int column) {
        this.columnData[column].resetFilter();
    }

    @Override
    public IBrowserColumn getFilterColumn(int column) {
        return this.columnData[column];
    }

    @Override
    public int getFilterColumnCount() {
        return this.columnData.length;
    }

    @Override
    public String[] getFilterColumnNames() {
        String[] names = new String[this.columnData.length];
        for (int i = 0; i < this.columnData.length; ++i) {
            names[i] = this.columnData[i].getName();
        }
        return names;
    }

    @Override
    public IBrowserColumnItem[] getResultColumnItems() {
        return this.resultData;
    }

    @Override
    public void selectPreviousFilterItem(int columnIndex) {
        this.columnData[columnIndex].selectPreviousItem();
    }

    @Override
    public void selectNextFilterItem(int columnIndex) {
        this.columnData[columnIndex].selectNextItem();
    }

    @Override
    public void previousFilterItemPage(int columnIndex) {
        this.columnData[columnIndex].scrollItemPageUp();
    }

    @Override
    public void nextFilterItemPage(int columnIndex) {
        this.columnData[columnIndex].scrollItemPageDown();
    }

    @Override
    public int getSelectedFilterItemIndex(int columnIndex) {
        return this.columnData[columnIndex].getCursorIndex();
    }

    public void setSelectedFilterItemIndex(int columnIndex, int index) {
        this.columnData[columnIndex].setCursorIndex(index);
    }

    public int getSelectedResultIndex() {
        for (int i = 0; i < this.numResults; ++i) {
            if (!this.resultData[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getNumResults() {
        return this.numResults;
    }

    @Override
    public int getNumFilterColumnEntries() {
        return this.numFilterColumnEntries;
    }
}

