/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.grid;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import java.util.Arrays;

public class PadGridImpl
implements PadGrid {
    protected IMidiOutput output;
    protected ColorManager colorManager;
    protected int[] currentButtonColors;
    protected int[] buttonColors;
    protected int[] currentBlinkColors;
    protected int[] blinkColors;
    protected boolean[] currentBlinkFast;
    protected boolean[] blinkFast;

    public PadGridImpl(ColorManager colorManager, IMidiOutput output) {
        this.colorManager = colorManager;
        this.output = output;
        this.currentButtonColors = new int[128];
        this.buttonColors = new int[128];
        this.currentBlinkColors = new int[128];
        this.blinkColors = new int[128];
        this.currentBlinkFast = new boolean[128];
        this.blinkFast = new boolean[128];
        int color = colorManager.getColor("GRID_COLOR_OFF");
        Arrays.fill(this.currentButtonColors, color);
        Arrays.fill(this.buttonColors, color);
        Arrays.fill(this.currentBlinkColors, color);
        Arrays.fill(this.blinkColors, color);
        Arrays.fill(this.currentBlinkFast, false);
        Arrays.fill(this.blinkFast, false);
    }

    @Override
    public void light(int note, int color) {
        this.setLight(note, color, -1, false);
    }

    @Override
    public void light(int note, int color, int blinkColor, boolean fast) {
        this.setLight(note, color, blinkColor, fast);
    }

    @Override
    public void lightEx(int x, int y, int color) {
        this.lightEx(x, y, color, -1, false);
    }

    @Override
    public void lightEx(int x, int y, int color, int blinkColor, boolean fast) {
        this.setLight(92 + x - 8 * y, color, blinkColor, fast);
    }

    @Override
    public void light(int note, String colorID) {
        this.light(note, colorID, null, false);
    }

    @Override
    public void lightEx(int x, int y, String colorID) {
        this.lightEx(x, y, colorID, null, false);
    }

    @Override
    public void light(int note, String colorID, String blinkColorID, boolean fast) {
        this.light(note, this.colorManager.getColor(colorID), blinkColorID == null ? -1 : this.colorManager.getColor(blinkColorID), fast);
    }

    @Override
    public void lightEx(int x, int y, String colorID, String blinkColorID, boolean fast) {
        this.lightEx(x, y, this.colorManager.getColor(colorID), blinkColorID == null ? -1 : this.colorManager.getColor(blinkColorID), fast);
    }

    protected void setLight(int index, int color, int blinkColor, boolean fast) {
        if (blinkColor >= 0) {
            this.buttonColors[index] = color;
            this.blinkColors[index] = blinkColor;
        } else {
            this.buttonColors[index] = color;
            this.blinkColors[index] = this.colorManager.getColor("GRID_COLOR_OFF");
        }
        this.blinkFast[index] = fast;
    }

    @Override
    public void forceFlush(int note) {
        this.currentButtonColors[note] = -1;
        this.currentBlinkColors[note] = -1;
        this.flush();
    }

    @Override
    public void forceFlush() {
        for (int i = 36; i < 100; ++i) {
            this.currentButtonColors[i] = -1;
            this.currentBlinkColors[i] = -1;
        }
        this.flush();
    }

    @Override
    public void flush() {
        for (int i = 36; i < 100; ++i) {
            int note = this.translateToController(i);
            boolean baseChanged = false;
            if (this.currentButtonColors[i] != this.buttonColors[i]) {
                this.currentButtonColors[i] = this.buttonColors[i];
                this.sendNoteState(note, this.buttonColors[i]);
                baseChanged = true;
            }
            if (!baseChanged && this.currentBlinkColors[i] == this.blinkColors[i] && this.currentBlinkFast[i] == this.blinkFast[i]) continue;
            this.currentBlinkColors[i] = this.blinkColors[i];
            this.currentBlinkFast[i] = this.blinkFast[i];
            this.sendNoteState(note, this.currentButtonColors[i]);
            if (this.blinkColors[i] == this.colorManager.getColor("GRID_COLOR_OFF")) continue;
            this.sendBlinkState(note, this.blinkColors[i], this.blinkFast[i]);
        }
    }

    protected void sendNoteState(int note, int color) {
        this.output.sendNote(note, color);
    }

    protected void sendBlinkState(int note, int blinkColor, boolean fast) {
        this.output.sendNoteEx(fast ? 14 : 10, note, blinkColor);
    }

    @Override
    public void turnOff() {
        int color = this.colorManager.getColor("GRID_COLOR_OFF");
        for (int i = 36; i < 100; ++i) {
            this.light(i, color, -1, false);
        }
        this.flush();
    }

    @Override
    public int translateToGrid(int note) {
        return note;
    }

    @Override
    public int translateToController(int note) {
        return note;
    }
}

